/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Module;
import org.easymock.EasyMock;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.softlayer.SoftLayerClient;
import org.jclouds.softlayer.compute.functions.DatacenterToLocationTest;
import org.jclouds.softlayer.compute.functions.VirtualGuestToNodeMetadata;
import org.jclouds.softlayer.domain.VirtualGuest;
import org.jclouds.softlayer.parse.ParseBadVirtualGuest;
import org.jclouds.softlayer.parse.ParseVirtualGuestHaltedTest;
import org.jclouds.softlayer.parse.ParseVirtualGuestPausedTest;
import org.jclouds.softlayer.parse.ParseVirtualGuestRunningTest;
import org.jclouds.softlayer.parse.ParseVirtualGuestWithNoPasswordTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VirtualGuestToNodeMetadataTest")
public class VirtualGuestToNodeMetadataTest {
    GroupNamingConvention.Factory namingConvention = (GroupNamingConvention.Factory)Guice.createInjector((Module[])new Module[0]).getInstance(GroupNamingConvention.Factory.class);

    @Test
    public void testApplyWhereVirtualGuestWithNoPassword() {
        VirtualGuest guest = new ParseVirtualGuestWithNoPasswordTest().expected();
        Location expectedLocation = DatacenterToLocationTest.function.apply(guest.getDatacenter());
        Supplier locationSupplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)expectedLocation));
        VirtualGuestToNodeMetadata parser = new VirtualGuestToNodeMetadata(locationSupplier, (VirtualGuestToNodeMetadata.GetHardwareForVirtualGuest)new GetHardwareForVirtualGuestMock(), (VirtualGuestToNodeMetadata.GetImageForVirtualGuest)new GetImageForVirtualGuestMock(), this.namingConvention);
        NodeMetadata node = parser.apply(guest);
        Assert.assertEquals((Object)node, (Object)new NodeMetadataBuilder().ids("416788").name("node1000360500").hostname("node1000360500").location(expectedLocation).status(NodeMetadata.Status.PENDING).publicAddresses((Iterable)ImmutableSet.of((Object)"173.192.29.186")).privateAddresses((Iterable)ImmutableSet.of((Object)"10.37.102.194")).hardware(new GetHardwareForVirtualGuestMock().getHardware(guest)).imageId(new GetImageForVirtualGuestMock().getImage(guest).getId()).operatingSystem(new GetImageForVirtualGuestMock().getImage(guest).getOperatingSystem()).build());
    }

    @Test
    public void testApplyWhereVirtualIsBad() {
        VirtualGuest guest = new ParseBadVirtualGuest().expected();
        Supplier locationSupplier = Suppliers.ofInstance((Object)ImmutableSet.of());
        VirtualGuestToNodeMetadata parser = new VirtualGuestToNodeMetadata(locationSupplier, (VirtualGuestToNodeMetadata.GetHardwareForVirtualGuest)new GetHardwareForVirtualGuestMock(), (VirtualGuestToNodeMetadata.GetImageForVirtualGuest)new GetImageForVirtualGuestMock(), this.namingConvention);
        NodeMetadata node = parser.apply(guest);
        Assert.assertEquals((Object)node, (Object)new NodeMetadataBuilder().ids("413348").name("foo-ef4").hostname("foo-ef4").group("foo").status(NodeMetadata.Status.PENDING).hardware(new GetHardwareForVirtualGuestMock().getHardware(guest)).imageId(new GetImageForVirtualGuestMock().getImage(guest).getId()).operatingSystem(new GetImageForVirtualGuestMock().getImage(guest).getOperatingSystem()).build());
    }

    @Test
    public void testApplyWhereVirtualGuestIsHalted() {
        VirtualGuest guest = new ParseVirtualGuestHaltedTest().expected();
        Location expectedLocation = DatacenterToLocationTest.function.apply(guest.getDatacenter());
        Supplier locationSupplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)expectedLocation));
        VirtualGuestToNodeMetadata parser = new VirtualGuestToNodeMetadata(locationSupplier, (VirtualGuestToNodeMetadata.GetHardwareForVirtualGuest)new GetHardwareForVirtualGuestMock(), (VirtualGuestToNodeMetadata.GetImageForVirtualGuest)new GetImageForVirtualGuestMock(), this.namingConvention);
        NodeMetadata node = parser.apply(guest);
        Assert.assertEquals((Object)node, (Object)new NodeMetadataBuilder().ids("416700").name("node1703810489").hostname("node1703810489").location(expectedLocation).status(NodeMetadata.Status.PENDING).publicAddresses((Iterable)ImmutableSet.of((Object)"173.192.29.187")).privateAddresses((Iterable)ImmutableSet.of((Object)"10.37.102.195")).hardware(new GetHardwareForVirtualGuestMock().getHardware(guest)).imageId(new GetImageForVirtualGuestMock().getImage(guest).getId()).operatingSystem(new GetImageForVirtualGuestMock().getImage(guest).getOperatingSystem()).build());
    }

    @Test
    public void testApplyWhereVirtualGuestIsPaused() {
        VirtualGuest guest = new ParseVirtualGuestPausedTest().expected();
        Location expectedLocation = DatacenterToLocationTest.function.apply(guest.getDatacenter());
        Supplier locationSupplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)expectedLocation));
        VirtualGuestToNodeMetadata parser = new VirtualGuestToNodeMetadata(locationSupplier, (VirtualGuestToNodeMetadata.GetHardwareForVirtualGuest)new GetHardwareForVirtualGuestMock(), (VirtualGuestToNodeMetadata.GetImageForVirtualGuest)new GetImageForVirtualGuestMock(), this.namingConvention);
        NodeMetadata node = parser.apply(guest);
        Assert.assertEquals((Object)node, (Object)new NodeMetadataBuilder().ids("416700").name("node1703810489").hostname("node1703810489").location(expectedLocation).status(NodeMetadata.Status.SUSPENDED).publicAddresses((Iterable)ImmutableSet.of((Object)"173.192.29.187")).privateAddresses((Iterable)ImmutableSet.of((Object)"10.37.102.195")).hardware(new GetHardwareForVirtualGuestMock().getHardware(guest)).imageId(new GetImageForVirtualGuestMock().getImage(guest).getId()).operatingSystem(new GetImageForVirtualGuestMock().getImage(guest).getOperatingSystem()).build());
    }

    @Test
    public void testApplyWhereVirtualGuestIsRunning() {
        VirtualGuest guest = new ParseVirtualGuestRunningTest().expected();
        Location expectedLocation = DatacenterToLocationTest.function.apply(guest.getDatacenter());
        Supplier locationSupplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)expectedLocation));
        VirtualGuestToNodeMetadata parser = new VirtualGuestToNodeMetadata(locationSupplier, (VirtualGuestToNodeMetadata.GetHardwareForVirtualGuest)new GetHardwareForVirtualGuestMock(), (VirtualGuestToNodeMetadata.GetImageForVirtualGuest)new GetImageForVirtualGuestMock(), this.namingConvention);
        NodeMetadata node = parser.apply(guest);
        Assert.assertEquals((Object)node, (Object)new NodeMetadataBuilder().ids("416700").name("node1703810489").hostname("node1703810489").location(expectedLocation).status(NodeMetadata.Status.RUNNING).publicAddresses((Iterable)ImmutableSet.of((Object)"173.192.29.187")).privateAddresses((Iterable)ImmutableSet.of((Object)"10.37.102.195")).hardware(new GetHardwareForVirtualGuestMock().getHardware(guest)).imageId(new GetImageForVirtualGuestMock().getImage(guest).getId()).operatingSystem(new GetImageForVirtualGuestMock().getImage(guest).getOperatingSystem()).build());
    }

    private static class GetImageForVirtualGuestMock
    extends VirtualGuestToNodeMetadata.GetImageForVirtualGuest {
        public GetImageForVirtualGuestMock() {
            super(null);
        }

        public Image getImage(VirtualGuest guest) {
            return new ImageBuilder().ids("123").description("mocked image").operatingSystem(OperatingSystem.builder().description("foo os").build()).status(Image.Status.AVAILABLE).build();
        }
    }

    private static class GetHardwareForVirtualGuestMock
    extends VirtualGuestToNodeMetadata.GetHardwareForVirtualGuest {
        public GetHardwareForVirtualGuestMock() {
            super((SoftLayerClient)EasyMock.createNiceMock(SoftLayerClient.class), (Function)EasyMock.createNiceMock(Function.class));
        }

        public Hardware getHardware(VirtualGuest guest) {
            return new HardwareBuilder().ids("mocked hardware").build();
        }
    }
}

