/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.options;

import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.softlayer.compute.options.SoftLayerTemplateOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SoftLayerTemplateOptionsTest")
public class SoftLayerTemplateOptionsTest {
    @Test
    public void testAs() {
        SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
        Assert.assertEquals((Object)options.as(SoftLayerTemplateOptions.class), (Object)options);
    }

    @Test
    public void testDefaultDomainName() {
        SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
        Assert.assertEquals((String)((SoftLayerTemplateOptions)options.as(SoftLayerTemplateOptions.class)).getDomainName(), (String)"jclouds.org");
    }

    @Test
    public void testDomainName() {
        TemplateOptions options = new SoftLayerTemplateOptions().domainName("me.com");
        Assert.assertEquals((String)((SoftLayerTemplateOptions)options.as(SoftLayerTemplateOptions.class)).getDomainName(), (String)"me.com");
    }

    @Test
    public void testDomainNameStatic() {
        SoftLayerTemplateOptions options = SoftLayerTemplateOptions.Builder.domainName((String)"me.com");
        Assert.assertEquals((String)((SoftLayerTemplateOptions)options.as(SoftLayerTemplateOptions.class)).getDomainName(), (String)"me.com");
    }

    @Test
    public void testDomainNameNullHasDecentMessage() {
        try {
            new SoftLayerTemplateOptions().domainName(null);
            Assert.fail((String)"should NPE");
        }
        catch (NullPointerException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"domainName was null");
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testDomainNameIsInvalidThrowsIllegalArgument() {
        new SoftLayerTemplateOptions().domainName("foo");
    }
}

