/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.features;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.internal.BaseRestClientExpectTest;
import org.jclouds.softlayer.SoftLayerClient;
import org.jclouds.softlayer.domain.ProductPackage;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AccountClientExpectTest")
public class AccountClientExpectTest
extends BaseRestClientExpectTest<SoftLayerClient> {
    public static String ACTIVE_PACKAGE_MASK = "id;name";

    public AccountClientExpectTest() {
        this.provider = "softlayer";
    }

    public void testGetActivePackagesWhenResponseIs2xx() {
        SoftLayerClient client = (SoftLayerClient)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api.softlayer.com/rest/v3/SoftLayer_Account/ActivePackages.json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/get_active_packages.json"))).build());
        Assert.assertEquals((Set)client.getAccountClient().getActivePackages(), (Set)ImmutableSet.of((Object)ProductPackage.builder().id(13).name("Dual Xeon (Dual Core) Woodcrest/Cloverton").description("<div class=\"PageTopicSubHead\">Dual Processor Multi-core Servers</div>").build(), (Object)ProductPackage.builder().id(15).name("Single Xeon (Dual Core) Woodcrest/Cloverton").description("<div class=\"PageTopicSubHead\">Single Processor Multi-core Servers</div>").build()));
    }

    public void testGetActivePackagesWhenResponseIs404() {
        SoftLayerClient client = (SoftLayerClient)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api.softlayer.com/rest/v3/SoftLayer_Account/ActivePackages.json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((Set)client.getAccountClient().getActivePackages(), null);
    }

    public void testGetReducedActivePackagesWhenResponseIs2xx() {
        SoftLayerClient client = (SoftLayerClient)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api.softlayer.com/rest/v3/SoftLayer_Account/ActivePackages.json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addQueryParam("objectMask", new String[]{ACTIVE_PACKAGE_MASK}).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/get_reduced_active_packages.json"))).build());
        Assert.assertEquals((Set)client.getAccountClient().getReducedActivePackages(), (Set)ImmutableSet.of((Object)ProductPackage.builder().id(13).name("Dual Xeon (Dual Core) Woodcrest/Cloverton").description("<div class=\"PageTopicSubHead\">Dual Processor Multi-core Servers</div>").build(), (Object)ProductPackage.builder().id(15).name("Single Xeon (Dual Core) Woodcrest/Cloverton").description("<div class=\"PageTopicSubHead\">Single Processor Multi-core Servers</div>").build()));
    }

    public void testGetReducedActivePackagesWhenResponseIs404() {
        SoftLayerClient client = (SoftLayerClient)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api.softlayer.com/rest/v3/SoftLayer_Account/ActivePackages.json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addQueryParam("objectMask", new String[]{ACTIVE_PACKAGE_MASK}).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((Set)client.getAccountClient().getReducedActivePackages(), null);
    }
}

