/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.features;

import java.util.Set;
import org.jclouds.apis.BaseApiLiveTest;
import org.jclouds.softlayer.SoftLayerClient;
import org.jclouds.softlayer.domain.ProductItem;
import org.jclouds.softlayer.domain.ProductItemCategory;
import org.jclouds.softlayer.domain.ProductItemPrice;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class BaseSoftLayerClientLiveTest
extends BaseApiLiveTest<SoftLayerClient> {
    public BaseSoftLayerClientLiveTest() {
        this.provider = "softlayer";
    }

    public void checkProductItem(ProductItem item) {
        Assert.assertTrue((item.getId() > 0 ? 1 : 0) != 0, (String)"item id must be more than 0");
        Assert.assertNotNull((Object)item.getDescription(), (String)"item description must be not null");
        this.checkCategories(item.getCategories());
        Assert.assertFalse((boolean)item.getPrices().isEmpty());
        for (ProductItemPrice price : item.getPrices()) {
            this.checkPrice(price);
        }
    }

    public void checkCategories(Set<ProductItemCategory> categories) {
        for (ProductItemCategory category : categories) {
            Assert.assertTrue((category.getId() > 0 ? 1 : 0) != 0, (String)"category id must be more than 0");
            Assert.assertNotNull((Object)category.getName(), (String)"category name must be not null");
            Assert.assertNotNull((Object)category.getCategoryCode(), (String)"category code must be not null");
        }
    }

    public void checkPrice(ProductItemPrice price) {
        Assert.assertTrue((price.getId() > 0 ? 1 : 0) != 0, (String)"price id must be more than 0");
        Assert.assertTrue((price.getItemId() > 0L ? 1 : 0) != 0, (String)"price itemId must be more than 0");
        Assert.assertTrue((price.getRecurringFee() != null || price.getHourlyRecurringFee() != null ? 1 : 0) != 0, (String)"price.getRecurringFee() must be not null OR price.getHourlyRecurringFee() must be not null");
    }
}

