/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.softlayer.features.BaseSoftLayerAsyncClientTest;
import org.jclouds.softlayer.features.DatacenterAsyncClient;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class DatacenterAsyncClientTest
extends BaseSoftLayerAsyncClientTest<DatacenterAsyncClient> {
    public void testListDatacenters() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(DatacenterAsyncClient.class, (String)"listDatacenters", (Class[])new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.softlayer.com/rest/v3/SoftLayer_Location_Datacenter/Datacenters.json?objectMask=locationAddress%3Bregions HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.softlayer.com/rest/v3/SoftLayer_Location_Datacenter/Datacenters.json?objectMask=locationAddress%3Bregions HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\nAuthorization: Basic aWRlbnRpdHk6Y3JlZGVudGlhbA==\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseJson.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetDatacenter() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(DatacenterAsyncClient.class, (String)"getDatacenter", (Class[])new Class[]{Long.TYPE});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)1234));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.softlayer.com/rest/v3/SoftLayer_Location_Datacenter/1234.json?objectMask=locationAddress%3Bregions HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseJson.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }
}

