/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.features;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.jclouds.softlayer.SoftLayerClient;
import org.jclouds.softlayer.domain.Address;
import org.jclouds.softlayer.domain.Datacenter;
import org.jclouds.softlayer.domain.Region;
import org.jclouds.softlayer.features.BaseSoftLayerClientLiveTest;
import org.jclouds.softlayer.features.DatacenterClient;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class DatacenterClientLiveTest
extends BaseSoftLayerClientLiveTest {
    @Test
    public void testListDatacenters() {
        Set response = this.api().listDatacenters();
        assert (null != response);
        Assert.assertTrue((response.size() >= 0 ? 1 : 0) != 0);
        for (Datacenter vg : response) {
            Datacenter newDetails = this.api().getDatacenter((long)vg.getId());
            Assert.assertEquals((int)vg.getId(), (int)newDetails.getId());
            this.checkDatacenter(newDetails);
        }
    }

    @Test
    public void testListDatacentersContent() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)Datacenter.builder().id(265592).name("ams01").longName("Amsterdam 1").build());
        builder.add((Object)Datacenter.builder().id(3).name("dal01").longName("Dallas").build());
        builder.add((Object)Datacenter.builder().id(154770).name("dal02").longName("Dallas 2").build());
        builder.add((Object)Datacenter.builder().id(167092).name("dal04").longName("Dallas 4").build());
        builder.add((Object)Datacenter.builder().id(138124).name("dal05").longName("Dallas 5").build());
        builder.add((Object)Datacenter.builder().id(154820).name("dal06").longName("Dallas 6").build());
        builder.add((Object)Datacenter.builder().id(142776).name("dal07").longName("Dallas 7").build());
        builder.add((Object)Datacenter.builder().id(142775).name("hou02").longName("Houston 2").build());
        builder.add((Object)Datacenter.builder().id(18171).name("sea01").longName("Seattle").build());
        builder.add((Object)Datacenter.builder().id(168642).name("sjc01").longName("San Jose 1").build());
        builder.add((Object)Datacenter.builder().id(224092).name("sng01").longName("Singapore 1").build());
        builder.add((Object)Datacenter.builder().id(37473).name("wdc01").longName("Washington, DC").build());
        Set response = this.api().listDatacenters();
        ImmutableSet expected = builder.build();
        Assert.assertEquals((int)response.size(), (int)expected.size());
        Assert.assertTrue((boolean)response.containsAll((Collection<?>)expected));
        for (Datacenter datacenter : response) {
            Address address = datacenter.getLocationAddress();
            if (address == null) continue;
            this.checkAddress(address);
        }
    }

    private DatacenterClient api() {
        return ((SoftLayerClient)this.api).getDatacenterClient();
    }

    private void checkDatacenter(Datacenter dc) {
        assert (dc.getId() > 0) : dc;
        assert (dc.getName() != null) : dc;
        assert (dc.getLongName() != null) : dc;
        for (Region region : dc.getRegions()) {
            this.checkRegion(region);
        }
    }

    private void checkRegion(Region region) {
        assert (!region.getDescription().isEmpty()) : region;
        assert (!region.getKeyname().isEmpty()) : region;
    }

    private void checkAddress(Address address) {
        assert (address.getId() > 0) : address;
        assert (address.getCountry() != null) : address;
    }
}

