/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.features;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.softlayer.features.BaseSoftLayerAsyncClientTest;
import org.jclouds.softlayer.features.ProductPackageAsyncClient;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ProductPackageAsyncClientTest
extends BaseSoftLayerAsyncClientTest<ProductPackageAsyncClient> {
    public void testGetProductPackage() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ProductPackageAsyncClient.class, (String)"getProductPackage", (Class[])new Class[]{Long.TYPE});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)1234));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.softlayer.com/rest/v3/SoftLayer_Product_Package/1234.json?objectMask=items.prices%3Bitems.categories%3Blocations.locationAddress%3Blocations.regions HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseJson.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }
}

