/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.features;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Set;
import org.jclouds.softlayer.SoftLayerClient;
import org.jclouds.softlayer.compute.functions.ProductItems;
import org.jclouds.softlayer.domain.Address;
import org.jclouds.softlayer.domain.Datacenter;
import org.jclouds.softlayer.domain.ProductItem;
import org.jclouds.softlayer.domain.ProductItemPrice;
import org.jclouds.softlayer.domain.ProductPackage;
import org.jclouds.softlayer.domain.Region;
import org.jclouds.softlayer.features.AccountClient;
import org.jclouds.softlayer.features.BaseSoftLayerClientLiveTest;
import org.jclouds.softlayer.features.ProductPackageClient;
import org.jclouds.softlayer.predicates.ProductItemPredicates;
import org.jclouds.softlayer.predicates.ProductPackagePredicates;
import org.testng.Assert;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="ProductPackageClientLiveTest")
public class ProductPackageClientLiveTest
extends BaseSoftLayerClientLiveTest {
    public static final String CLOUD_SERVER_PACKAGE_NAME = "Cloud Server";
    private ProductPackageClient client;
    private AccountClient accountClient;
    private int cloudServerPackageId;
    private ProductPackage cloudServerProductPackage;

    @BeforeGroups(groups={"live"})
    public void setup() {
        super.setup();
        this.client = ((SoftLayerClient)this.api).getProductPackageClient();
        this.accountClient = ((SoftLayerClient)this.api).getAccountClient();
        this.cloudServerPackageId = ((ProductPackage)Iterables.find((Iterable)this.accountClient.getActivePackages(), (Predicate)ProductPackagePredicates.named((String)CLOUD_SERVER_PACKAGE_NAME))).getId();
        this.cloudServerProductPackage = this.client.getProductPackage((long)this.cloudServerPackageId);
    }

    @Test
    public void testGetProductPackage() {
        for (ProductPackage productPackage : this.accountClient.getReducedActivePackages()) {
            ProductPackage response = this.client.getProductPackage((long)productPackage.getId());
            assert (null != response);
            assert (response.getId() > 0) : response;
            assert (response.getName() != null) : response;
            Assert.assertTrue((response.getItems().size() >= 0 ? 1 : 0) != 0);
            for (ProductItem item : response.getItems()) {
                this.checkProductItem(item);
            }
            for (Datacenter datacenter : response.getDatacenters()) {
                this.checkDatacenter(datacenter);
            }
        }
    }

    @Test
    public void testDatacentersForCloudLayer() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)Datacenter.builder().id(18171).name("sea01").longName("Seattle").build());
        builder.add((Object)Datacenter.builder().id(37473).name("wdc01").longName("Washington, DC").build());
        builder.add((Object)Datacenter.builder().id(138124).name("dal05").longName("Dallas 5").build());
        builder.add((Object)Datacenter.builder().id(168642).name("sjc01").longName("San Jose 1").build());
        builder.add((Object)Datacenter.builder().id(224092).name("sng01").longName("Singapore 1").build());
        builder.add((Object)Datacenter.builder().id(265592).name("ams01").longName("Amsterdam 1").build());
        ImmutableSet expected = builder.build();
        Set datacenters = this.cloudServerProductPackage.getDatacenters();
        assert (datacenters.size() == expected.size()) : datacenters;
        Assert.assertTrue((boolean)datacenters.containsAll((Collection<?>)expected));
        for (Datacenter dataCenter : datacenters) {
            Address address = dataCenter.getLocationAddress();
            Assert.assertNotNull((Object)address);
            this.checkAddress(address);
        }
    }

    @Test
    public void testGetOneGBRamPrice() {
        Iterable ramItems = Iterables.filter((Iterable)this.cloudServerProductPackage.getItems(), (Predicate)Predicates.and((Predicate)ProductItemPredicates.categoryCode((String)"ram"), (Predicate)ProductItemPredicates.capacity((Float)Float.valueOf(1.0f))));
        ImmutableMap ramToProductItem = Maps.uniqueIndex((Iterable)ramItems, (Function)ProductItems.capacity());
        ProductItemPrice price = (ProductItemPrice)ProductItems.price().apply(ramToProductItem.get(Float.valueOf(1.0f)));
        assert (Integer.valueOf(1644).equals(price.getId()));
    }

    @Test
    public void testGetTwoCPUCoresPrice() {
        Iterable cpuItems = Iterables.filter((Iterable)this.cloudServerProductPackage.getItems(), (Predicate)Predicates.and((Predicate)ProductItemPredicates.units((String)"PRIVATE_CORE"), (Predicate)ProductItemPredicates.capacity((Float)Float.valueOf(2.0f))));
        ImmutableMap coresToProductItem = Maps.uniqueIndex((Iterable)cpuItems, (Function)ProductItems.capacity());
        ProductItemPrice price = (ProductItemPrice)ProductItems.price().apply(coresToProductItem.get(Float.valueOf(2.0f)));
        assert (Integer.valueOf(1963).equals(price.getId()));
    }

    @Test
    public void testGetUbuntuPrice() {
        Iterable operatingSystems = Iterables.filter((Iterable)this.cloudServerProductPackage.getItems(), (Predicate)ProductItemPredicates.categoryCode((String)"os"));
        ImmutableMap osToProductItem = Maps.uniqueIndex((Iterable)operatingSystems, (Function)ProductItems.description());
        ProductItemPrice price = (ProductItemPrice)ProductItems.price().apply(osToProductItem.get("Ubuntu Linux 8 LTS Hardy Heron - Minimal Install (64 bit)"));
        assert (Integer.valueOf(1693).equals(price.getId()));
    }

    private void checkDatacenter(Datacenter datacenter) {
        assert (datacenter.getId() > 0) : datacenter;
        assert (datacenter.getName() != null) : datacenter;
        assert (datacenter.getLongName() != null) : datacenter;
        for (Region region : datacenter.getRegions()) {
            this.checkRegion(region);
        }
    }

    private void checkRegion(Region region) {
        assert (!region.getDescription().isEmpty()) : region;
        assert (!region.getKeyname().isEmpty()) : region;
    }

    private void checkAddress(Address address) {
        assert (address.getId() > 0) : address;
        assert (address.getCountry() != null) : address;
        if (!ImmutableSet.of((Object)"SG", (Object)"NL").contains((Object)address.getCountry())) assert (address.getState() != null) : address;
    }
}

