/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.softlayer.features.BaseSoftLayerAsyncClientTest;
import org.jclouds.softlayer.features.VirtualGuestAsyncClient;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class VirtualGuestAsyncClientTest
extends BaseSoftLayerAsyncClientTest<VirtualGuestAsyncClient> {
    public void testListVirtualGuests() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VirtualGuestAsyncClient.class, (String)"listVirtualGuests", (Class[])new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.softlayer.com/rest/v3/SoftLayer_Account/VirtualGuests.json?objectMask=virtualGuests.powerState%3BvirtualGuests.networkVlans%3BvirtualGuests.operatingSystem.passwords%3BvirtualGuests.datacenter%3BvirtualGuests.billingItem HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.softlayer.com/rest/v3/SoftLayer_Account/VirtualGuests.json?objectMask=virtualGuests.powerState%3BvirtualGuests.networkVlans%3BvirtualGuests.operatingSystem.passwords%3BvirtualGuests.datacenter%3BvirtualGuests.billingItem HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\nAuthorization: Basic aWRlbnRpdHk6Y3JlZGVudGlhbA==\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseJson.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetVirtualGuest() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VirtualGuestAsyncClient.class, (String)"getVirtualGuest", (Class[])new Class[]{Long.TYPE});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)1234));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.softlayer.com/rest/v3/SoftLayer_Virtual_Guest/1234.json?objectMask=powerState%3BnetworkVlans%3BoperatingSystem.passwords%3Bdatacenter%3BbillingItem HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseJson.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testRebootHardVirtualGuest() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VirtualGuestAsyncClient.class, (String)"rebootHardVirtualGuest", (Class[])new Class[]{Long.TYPE});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)1234));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.softlayer.com/rest/v3/SoftLayer_Virtual_Guest/1234/rebootHard.json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testPowerOffVirtualGuest() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VirtualGuestAsyncClient.class, (String)"powerOffVirtualGuest", (Class[])new Class[]{Long.TYPE});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)1234));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.softlayer.com/rest/v3/SoftLayer_Virtual_Guest/1234/powerOff.json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testPowerOnVirtualGuest() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VirtualGuestAsyncClient.class, (String)"powerOnVirtualGuest", (Class[])new Class[]{Long.TYPE});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)1234));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.softlayer.com/rest/v3/SoftLayer_Virtual_Guest/1234/powerOn.json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testPauseVirtualGuest() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VirtualGuestAsyncClient.class, (String)"pauseVirtualGuest", (Class[])new Class[]{Long.TYPE});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)1234));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.softlayer.com/rest/v3/SoftLayer_Virtual_Guest/1234/pause.json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testResumeVirtualGuest() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VirtualGuestAsyncClient.class, (String)"resumeVirtualGuest", (Class[])new Class[]{Long.TYPE});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)1234));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.softlayer.com/rest/v3/SoftLayer_Virtual_Guest/1234/resume.json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }
}

