/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.features;

import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.internal.BaseRestClientExpectTest;
import org.jclouds.softlayer.SoftLayerClient;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SoftLayerClientExpectTest")
public class VirtualGuestClientExpectTest
extends BaseRestClientExpectTest<SoftLayerClient> {
    public VirtualGuestClientExpectTest() {
        this.provider = "softlayer";
    }

    public void testCancelGuestReturnsTrueOn200AndFalseOn404() {
        HttpRequest cancelGuest11 = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api.softlayer.com/rest/v3/SoftLayer_Billing_Item/11/cancelService.json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).build();
        HttpResponse found = HttpResponse.builder().statusCode(200).build();
        SoftLayerClient clientWhenServiceExists = (SoftLayerClient)this.requestSendsResponse(cancelGuest11, found);
        assert (clientWhenServiceExists.getVirtualGuestClient().cancelService(11L));
        HttpResponse notFound = HttpResponse.builder().statusCode(404).build();
        SoftLayerClient clientWhenServiceDoesntExist = (SoftLayerClient)this.requestSendsResponse(cancelGuest11, notFound);
        assert (!clientWhenServiceDoesntExist.getVirtualGuestClient().cancelService(11L));
    }
}

