/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.features;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.softlayer.SoftLayerClient;
import org.jclouds.softlayer.domain.ProductItem;
import org.jclouds.softlayer.domain.ProductItemPrice;
import org.jclouds.softlayer.domain.ProductOrder;
import org.jclouds.softlayer.domain.ProductOrderReceipt;
import org.jclouds.softlayer.domain.ProductPackage;
import org.jclouds.softlayer.domain.VirtualGuest;
import org.jclouds.softlayer.features.BaseSoftLayerClientLiveTest;
import org.jclouds.softlayer.features.VirtualGuestClient;
import org.jclouds.softlayer.predicates.ProductItemPredicates;
import org.jclouds.softlayer.predicates.ProductPackagePredicates;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class VirtualGuestClientLiveTest
extends BaseSoftLayerClientLiveTest {
    private static final String TEST_HOSTNAME_PREFIX = "livetest";
    private TemplateBuilder templateBuilder;
    private Iterable<ProductItemPrice> defaultPrices;

    @Test
    public void testListVirtualGuests() throws Exception {
        Set response = this.api().listVirtualGuests();
        assert (null != response);
        Assert.assertTrue((response.size() >= 0 ? 1 : 0) != 0);
        for (VirtualGuest vg : response) {
            VirtualGuest newDetails = this.api().getVirtualGuest((long)vg.getId());
            Assert.assertEquals((int)vg.getId(), (int)newDetails.getId());
            this.checkVirtualGuest(vg);
        }
    }

    @Test(groups={"live"})
    public void testCancelAndPlaceOrder() {
        for (VirtualGuest guest : this.api().listVirtualGuests()) {
            if (!guest.getHostname().startsWith(TEST_HOSTNAME_PREFIX) || guest.getBillingItemId() == -1) continue;
            this.api().cancelService((long)guest.getBillingItemId());
        }
        int pkgId = ((ProductPackage)Iterables.find((Iterable)((SoftLayerClient)this.api).getAccountClient().getActivePackages(), (Predicate)ProductPackagePredicates.named((String)"Cloud Server"))).getId();
        ProductPackage productPackage = ((SoftLayerClient)this.api).getProductPackageClient().getProductPackage((long)pkgId);
        VirtualGuest guest = VirtualGuest.builder().domain("jclouds.org").hostname(TEST_HOSTNAME_PREFIX + new Random().nextInt()).build();
        Template template = this.templateBuilder.build();
        ProductOrder order = ProductOrder.builder().packageId(productPackage.getId()).quantity(1).location(template.getLocation().getId()).useHourlyPricing(true).prices(this.getPrices(template, productPackage)).virtualGuests(new VirtualGuest[]{guest}).build();
        ProductOrderReceipt receipt = this.api().orderVirtualGuest(order);
        ProductOrder order2 = receipt.getOrderDetails();
        Assert.assertEquals((Set)order.getPrices(), (Set)order2.getPrices());
        Assert.assertNotNull((Object)receipt);
    }

    protected SoftLayerClient create(Properties props, Iterable<Module> modules) {
        Injector injector = this.newBuilder().modules(modules).overrides(props).buildInjector();
        this.templateBuilder = (TemplateBuilder)injector.getInstance(TemplateBuilder.class);
        this.defaultPrices = (Iterable)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Iterable<ProductItemPrice>>(){}));
        return (SoftLayerClient)injector.getInstance(SoftLayerClient.class);
    }

    private VirtualGuestClient api() {
        return ((SoftLayerClient)this.api).getVirtualGuestClient();
    }

    private void checkVirtualGuest(VirtualGuest vg) {
        if (vg.getBillingItemId() == -1) {
            return;
        }
        assert (vg.getAccountId() > 0) : vg;
        assert (vg.getCreateDate() != null) : vg;
        assert (vg.getDomain() != null) : vg;
        assert (vg.getFullyQualifiedDomainName() != null) : vg;
        assert (vg.getHostname() != null) : vg;
        assert (vg.getId() > 0) : vg;
        assert (vg.getMaxCpu() > 0) : vg;
        assert (vg.getMaxCpuUnits() != null) : vg;
        assert (vg.getMaxMemory() > 0) : vg;
        assert (vg.getStartCpus() > 0) : vg;
        assert (vg.getStatusId() >= 0) : vg;
        assert (vg.getUuid() != null) : vg;
        assert (vg.getPrimaryBackendIpAddress() != null) : vg;
        assert (vg.getPrimaryIpAddress() != null) : vg;
    }

    private Iterable<ProductItemPrice> getPrices(Template template, ProductPackage productPackage) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        int imageId = Integer.parseInt(template.getImage().getId());
        result.add((Object)ProductItemPrice.builder().id(imageId).build());
        Iterable hardwareIds = Splitter.on((String)",").split((CharSequence)template.getHardware().getId());
        for (String hardwareId : hardwareIds) {
            int id = Integer.parseInt(hardwareId);
            result.add((Object)ProductItemPrice.builder().id(id).build());
        }
        float portSpeed = 10.0f;
        ProductItem uplinkItem = (ProductItem)Iterables.find((Iterable)productPackage.getItems(), (Predicate)Predicates.and((Predicate)ProductItemPredicates.capacity((Float)Float.valueOf(portSpeed)), (Predicate)ProductItemPredicates.categoryCode((String)"port_speed")));
        result.add(Iterables.get((Iterable)uplinkItem.getPrices(), (int)0));
        result.addAll(this.defaultPrices);
        return result.build();
    }
}

