/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.handlers;

import com.google.inject.Guice;
import com.google.inject.Module;
import java.net.URI;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.softlayer.handlers.SoftLayerErrorHandler;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class SoftLayerErrorHandlerTest {
    @Test
    public void test500MakesResourceNotFoundExceptionOnUnableToDeterminePackage() {
        this.assertCodeMakes("GET", URI.create("https://api.softlayer.com/foo"), 500, "", "{\"error\":\"Unable to determine package for 'node2102835255.me.org'.\"}", ResourceNotFoundException.class);
    }

    @Test
    public void test500MakesIllegalStateExceptionOnActiveTransaction() {
        this.assertCodeMakes("GET", URI.create("https://api.softlayer.com/rest/v3/SoftLayer_Billing_Item/8676376/cancelService.json"), 500, "", "{\"error\":\"There is currently an active transaction.\"}", IllegalStateException.class);
    }

    @Test
    public void test401MakesAuthorizationException() {
        this.assertCodeMakes("GET", URI.create("https://api.softlayer.com/foo"), 401, "", "Unauthorized", AuthorizationException.class);
    }

    @Test
    public void test404MakesResourceNotFoundException() {
        this.assertCodeMakes("GET", URI.create("https://api.softlayer.com/foo"), 404, "", "Not Found", ResourceNotFoundException.class);
    }

    private void assertCodeMakes(String method, URI uri, int statusCode, String message, String content, Class<? extends Exception> expected) {
        this.assertCodeMakes(method, uri, statusCode, message, "text/xml", content, expected);
    }

    private void assertCodeMakes(String method, URI uri, int statusCode, String message, String contentType, String content, Class<? extends Exception> expected) {
        SoftLayerErrorHandler function = (SoftLayerErrorHandler)Guice.createInjector((Module[])new Module[0]).getInstance(SoftLayerErrorHandler.class);
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest request = HttpRequest.builder().method(method).endpoint(uri).build();
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(statusCode).message(message).payload(content)).build();
        response.getPayload().getContentMetadata().setContentType(contentType);
        EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)request).atLeastOnce();
        command.setException(SoftLayerErrorHandlerTest.classEq(expected));
        EasyMock.replay((Object[])new Object[]{command});
        function.handleError(command, response);
        EasyMock.verify((Object[])new Object[]{command});
    }

    public static Exception classEq(final Class<? extends Exception> in) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public void appendTo(StringBuffer buffer) {
                buffer.append("classEq(");
                buffer.append(in);
                buffer.append(")");
            }

            public boolean matches(Object arg) {
                return arg.getClass() == in;
            }
        });
        return null;
    }
}

