/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.parse;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import javax.ws.rs.Consumes;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.json.BaseItemParserTest;
import org.jclouds.json.config.GsonModule;
import org.jclouds.softlayer.config.SoftLayerParserModule;
import org.jclouds.softlayer.domain.PowerState;
import org.jclouds.softlayer.domain.VirtualGuest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ParseVirtualGuestWithNoPasswordTest")
public class ParseBadVirtualGuest
extends BaseItemParserTest<VirtualGuest> {
    public String resource() {
        return "/virtual_guest_bad_halted.json";
    }

    @Consumes(value={"application/json"})
    public VirtualGuest expected() {
        return VirtualGuest.builder().id(413348).accountId(93750).billingItemId(-1).createDate(new SimpleDateFormatDateService().iso8601SecondsDateParse("2011-09-28T01:52:45-08:00")).domain("jclouds.org").fullyQualifiedDomainName("foo-ef4.jclouds.org").hostname("foo-ef4").maxCpu(0).maxCpuUnits("CORE").maxMemory(256).statusId(1001).startCpus(0).powerState(new PowerState(VirtualGuest.State.HALTED)).build();
    }

    protected Injector injector() {
        return Guice.createInjector((Module[])new Module[]{new SoftLayerParserModule(), new GsonModule()});
    }
}

