/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.parse;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import javax.ws.rs.Consumes;
import org.jclouds.http.HttpResponse;
import org.jclouds.json.BaseItemParserTest;
import org.jclouds.json.config.GsonModule;
import org.jclouds.softlayer.compute.functions.ProductItems;
import org.jclouds.softlayer.config.SoftLayerParserModule;
import org.jclouds.softlayer.domain.ProductItem;
import org.jclouds.softlayer.domain.ProductItemPrice;
import org.jclouds.softlayer.domain.ProductOrder;
import org.jclouds.softlayer.predicates.ProductItemPredicates;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ParseProductOrderTest")
public class ParseProductOrderTest
extends BaseItemParserTest<ProductOrder> {
    public String resource() {
        return "/product_order_template.json";
    }

    @Consumes(value={"application/json"})
    public ProductOrder expected() {
        ImmutableSet prices = ImmutableSet.builder().add((Object)ProductItemPrice.builder().id(1962).itemId(1045L).recurringFee(Float.valueOf(0.0f)).hourlyRecurringFee(Float.valueOf(0.0f)).build()).add((Object)ProductItemPrice.builder().id(1644).itemId(861L).recurringFee(Float.valueOf(0.0f)).hourlyRecurringFee(Float.valueOf(0.0f)).build()).add((Object)ProductItemPrice.builder().id(905).itemId(503L).recurringFee(Float.valueOf(0.0f)).hourlyRecurringFee(Float.valueOf(0.0f)).build()).add((Object)ProductItemPrice.builder().id(274).itemId(188L).recurringFee(Float.valueOf(0.0f)).hourlyRecurringFee(Float.valueOf(0.0f)).build()).add((Object)ProductItemPrice.builder().id(1800).itemId(439L).recurringFee(Float.valueOf(0.0f)).hourlyRecurringFee(Float.valueOf(0.0f)).build()).add((Object)ProductItemPrice.builder().id(21).itemId(15L).recurringFee(Float.valueOf(0.0f)).hourlyRecurringFee(Float.valueOf(0.0f)).build()).add((Object)ProductItemPrice.builder().id(1639).itemId(865L).recurringFee(Float.valueOf(0.0f)).hourlyRecurringFee(Float.valueOf(0.0f)).build()).add((Object)ProductItemPrice.builder().id(1693).itemId(884L).recurringFee(Float.valueOf(0.0f)).hourlyRecurringFee(Float.valueOf(0.0f)).build()).add((Object)ProductItemPrice.builder().id(55).itemId(49L).recurringFee(Float.valueOf(0.0f)).hourlyRecurringFee(Float.valueOf(0.0f)).build()).add((Object)ProductItemPrice.builder().id(57).itemId(51L).recurringFee(Float.valueOf(0.0f)).hourlyRecurringFee(Float.valueOf(0.0f)).build()).add((Object)ProductItemPrice.builder().id(58).itemId(52L).recurringFee(Float.valueOf(0.0f)).hourlyRecurringFee(Float.valueOf(0.0f)).build()).add((Object)ProductItemPrice.builder().id(420).itemId(309L).recurringFee(Float.valueOf(0.0f)).hourlyRecurringFee(Float.valueOf(0.0f)).build()).add((Object)ProductItemPrice.builder().id(418).itemId(307L).recurringFee(Float.valueOf(0.0f)).hourlyRecurringFee(Float.valueOf(0.0f)).build()).build();
        ProductOrder order = ProductOrder.builder().quantity(0).packageId(46).useHourlyPricing(true).prices((Iterable)prices).build();
        return order;
    }

    @Test
    public void test() {
        ProductOrder expects = this.expected();
        Function parser = this.parser(this.injector());
        ProductOrder response = (ProductOrder)parser.apply((Object)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(this.payload())).build());
        Assert.assertEquals((Object)response, (Object)expects);
        this.hasOs(response);
    }

    private void hasOs(ProductOrder order) {
        Iterable items = Iterables.transform((Iterable)order.getPrices(), (Function)ProductItems.item());
        ProductItem os = (ProductItem)Iterables.find((Iterable)ImmutableSet.copyOf((Iterable)items), (Predicate)ProductItemPredicates.categoryCode((String)"os"));
        Assert.assertNotNull((Object)os);
    }

    protected Injector injector() {
        return Guice.createInjector((Module[])new Module[]{new SoftLayerParserModule(), new GsonModule()});
    }
}

