/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.predicates;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jclouds.softlayer.domain.ProductItem;
import org.jclouds.softlayer.domain.ProductItemCategory;
import org.jclouds.softlayer.predicates.ProductItemPredicates;
import org.testng.Assert;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(singleThreaded=true, groups={"unit"})
public class ProductItemPredicatesTest {
    private ProductItemCategory ramCategory;
    private ProductItem item;
    private ProductItem emptyItem;

    @BeforeGroups(groups={"unit"})
    public void setupContext() {
        this.ramCategory = ProductItemCategory.builder().id(1).categoryCode("ram").build();
        this.item = ProductItem.builder().id(1).description("a test item").categories((Set)ImmutableSet.of((Object)this.ramCategory)).capacity(Float.valueOf(2.0f)).units("GB").build();
        this.emptyItem = ProductItem.builder().id(1).build();
    }

    @Test
    public void testCategoryCodePresent() {
        assert (ProductItemPredicates.categoryCode((String)"ram").apply((Object)this.item));
    }

    @Test
    public void testCategoryCodePresentTwoCategories() {
        ProductItemCategory osCategory = ProductItemCategory.builder().id(2).categoryCode("os").build();
        ProductItem item = ProductItem.builder().categories((Set)ImmutableSet.of((Object)this.ramCategory, (Object)osCategory)).build();
        assert (ProductItemPredicates.categoryCode((String)"ram").apply((Object)item));
    }

    @Test
    public void testCategoryCodeMissing() {
        Assert.assertFalse((boolean)ProductItemPredicates.categoryCode((String)"missing").apply((Object)this.emptyItem));
    }

    @Test
    public void testCategoryCodeMatches() {
        ProductItemPredicates.categoryCodeMatches((Pattern)Pattern.compile("ra.*")).apply((Object)this.item);
    }

    @Test
    public void testCapacityPresent() {
        assert (ProductItemPredicates.capacity((Float)Float.valueOf(2.0f)).apply((Object)this.item));
    }

    @Test
    public void testCapacityMissing() {
        Assert.assertFalse((boolean)ProductItemPredicates.capacity((Float)Float.valueOf(1.0f)).apply((Object)this.item));
    }

    @Test
    public void testUnitsPresent() {
        assert (ProductItemPredicates.units((String)"GB").apply((Object)this.item));
    }

    @Test
    public void testUnitsMissing() {
        Assert.assertFalse((boolean)ProductItemPredicates.units((String)"Kg").apply((Object)this.item));
    }

    @Test
    public void testMatchesRegex() {
        assert (ProductItemPredicates.matches((Pattern)Pattern.compile(".*test.*")).apply((Object)this.item));
    }

    @Test
    public void testNoMatchRegex() {
        Assert.assertFalse((boolean)ProductItemPredicates.matches((Pattern)Pattern.compile("no match")).apply((Object)this.item));
    }
}

