/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.internal.BaseProviderMetadata;
import org.jclouds.softlayer.SoftLayerApiMetadata;

public class SoftLayerProviderMetadata
extends BaseProviderMetadata {
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return SoftLayerProviderMetadata.builder().fromProviderMetadata((ProviderMetadata)this);
    }

    public SoftLayerProviderMetadata() {
        super((BaseProviderMetadata.Builder)SoftLayerProviderMetadata.builder());
    }

    public SoftLayerProviderMetadata(Builder builder) {
        super((BaseProviderMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = new Properties();
        properties.setProperty("jclouds.softlayer.virtualguest.order-delay", "3600000");
        properties.setProperty("jclouds.softlayer.virtualguest.package-name", "Cloud Server");
        properties.setProperty("jclouds.softlayer.virtualguest.cpu-regex", "[0-9]+ x ([0-9.]+) GHz Core[s]?");
        properties.setProperty("jclouds.softlayer.virtualguest.disk0-type", "LOCAL");
        properties.setProperty("jclouds.softlayer.virtualguest.port-speed", "10");
        ImmutableSet.Builder prices = ImmutableSet.builder();
        prices.add((Object)"21");
        prices.add((Object)"55");
        prices.add((Object)"57");
        prices.add((Object)"58");
        prices.add((Object)"1800");
        prices.add((Object)"905");
        prices.add((Object)"418");
        prices.add((Object)"420");
        properties.setProperty("jclouds.softlayer.virtualguest.prices", Joiner.on((char)',').join((Iterable)prices.build()));
        properties.setProperty("jclouds.template", "osFamily=UBUNTU,osVersionMatches=1[012].[01][04],os64Bit=true,osDescriptionMatches=.*Minimal Install.*");
        return properties;
    }

    public static class Builder
    extends BaseProviderMetadata.Builder {
        protected Builder() {
            this.id("softlayer").name("SoftLayer").apiMetadata((ApiMetadata)new SoftLayerApiMetadata()).homepage(URI.create("http://www.softlayer.com")).console(URI.create("https://manage.softlayer.com")).iso3166Codes(new String[]{"SG", "US-CA", "US-TX", "US-VA", "US-WA", "US-TX", "NL", "NSFTW-IL"}).endpoint("https://api.softlayer.com/rest").defaultProperties(SoftLayerProviderMetadata.defaultProperties());
        }

        public SoftLayerProviderMetadata build() {
            return new SoftLayerProviderMetadata(this);
        }

        public Builder fromProviderMetadata(ProviderMetadata in) {
            super.fromProviderMetadata(in);
            return this;
        }
    }
}

