/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.logging.Logger;
import org.jclouds.softlayer.SoftLayerClient;
import org.jclouds.softlayer.compute.functions.ProductItemToImage;
import org.jclouds.softlayer.compute.functions.ProductItems;
import org.jclouds.softlayer.domain.ProductItem;
import org.jclouds.softlayer.domain.ProductOrder;
import org.jclouds.softlayer.domain.VirtualGuest;
import org.jclouds.softlayer.exceptions.SoftLayerOrderItemDuplicateException;
import org.jclouds.softlayer.predicates.ProductItemPredicates;

@Singleton
public class VirtualGuestToNodeMetadata
implements Function<VirtualGuest, NodeMetadata> {
    public static final Map<VirtualGuest.State, NodeMetadata.Status> serverStateToNodeStatus = ImmutableMap.builder().put((Object)VirtualGuest.State.HALTED, (Object)NodeMetadata.Status.PENDING).put((Object)VirtualGuest.State.PAUSED, (Object)NodeMetadata.Status.SUSPENDED).put((Object)VirtualGuest.State.RUNNING, (Object)NodeMetadata.Status.RUNNING).put((Object)VirtualGuest.State.UNRECOGNIZED, (Object)NodeMetadata.Status.UNRECOGNIZED).build();
    private final Supplier<Set<? extends Location>> locations;
    private final GetHardwareForVirtualGuest hardware;
    private final GetImageForVirtualGuest images;
    private final GroupNamingConvention nodeNamingConvention;

    @Inject
    VirtualGuestToNodeMetadata(@Memoized Supplier<Set<? extends Location>> locations, GetHardwareForVirtualGuest hardware, GetImageForVirtualGuest images, GroupNamingConvention.Factory namingConvention) {
        this.nodeNamingConvention = ((GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)namingConvention, (Object)"namingConvention")).createWithoutPrefix();
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
        this.hardware = (GetHardwareForVirtualGuest)Preconditions.checkNotNull((Object)hardware, (Object)"hardware");
        this.images = (GetImageForVirtualGuest)Preconditions.checkNotNull((Object)images, (Object)"images");
    }

    public NodeMetadata apply(VirtualGuest from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getId() + "");
        builder.name(from.getHostname());
        builder.hostname(from.getHostname());
        if (from.getDatacenter() != null) {
            builder.location((Location)FluentIterable.from((Iterable)((Iterable)this.locations.get())).firstMatch(LocationPredicates.idEquals((String)(from.getDatacenter().getId() + ""))).orNull());
        }
        builder.group(this.nodeNamingConvention.groupInUniqueNameOrNull(from.getHostname()));
        Image image = this.images.getImage(from);
        if (image != null) {
            builder.imageId(image.getId());
            builder.operatingSystem(image.getOperatingSystem());
            builder.hardware(this.hardware.getHardware(from));
        }
        builder.status(serverStateToNodeStatus.get((Object)from.getPowerState().getKeyName()));
        if (from.getPrimaryIpAddress() != null) {
            builder.publicAddresses((Iterable)ImmutableSet.of((Object)from.getPrimaryIpAddress()));
        }
        if (from.getPrimaryBackendIpAddress() != null) {
            builder.privateAddresses((Iterable)ImmutableSet.of((Object)from.getPrimaryBackendIpAddress()));
        }
        return builder.build();
    }

    @Singleton
    public static class GetImageForVirtualGuest {
        @Resource
        @Named(value="jclouds.compute")
        protected Logger logger = Logger.NULL;
        private SoftLayerClient client;

        @Inject
        public GetImageForVirtualGuest(SoftLayerClient client) {
            this.client = client;
        }

        public Image getImage(VirtualGuest guest) {
            ProductOrder order = null;
            if (guest.getStartCpus() < 1) {
                return null;
            }
            try {
                order = this.client.getVirtualGuestClient().getOrderTemplate(guest.getId());
            }
            catch (SoftLayerOrderItemDuplicateException e) {
                this.logger.warn((Throwable)((Object)e), "Cannot get order template for virtualGuestId(%s)", new Object[]{guest.getId()});
            }
            if (order == null) {
                return null;
            }
            Iterable items = Iterables.transform(order.getPrices(), ProductItems.item());
            ProductItem os = (ProductItem)Iterables.find((Iterable)items, ProductItemPredicates.categoryCode("os"));
            if (os.getPrices().isEmpty()) {
                return null;
            }
            return new ProductItemToImage().apply(os);
        }
    }

    @Singleton
    public static class GetHardwareForVirtualGuest {
        private final SoftLayerClient client;
        private final Function<Iterable<ProductItem>, Hardware> productItemsToHardware;

        @Inject
        public GetHardwareForVirtualGuest(SoftLayerClient client, Function<Iterable<ProductItem>, Hardware> productItemsToHardware) {
            this.client = (SoftLayerClient)Preconditions.checkNotNull((Object)client, (Object)"client");
            this.productItemsToHardware = (Function)Preconditions.checkNotNull(productItemsToHardware, (Object)"productItemsToHardware");
        }

        public Hardware getHardware(VirtualGuest guest) {
            if (guest.getStartCpus() < 1) {
                return null;
            }
            ProductOrder order = this.client.getVirtualGuestClient().getOrderTemplate(guest.getId());
            if (order == null) {
                return null;
            }
            Iterable items = Iterables.transform(order.getPrices(), ProductItems.item());
            return (Hardware)this.productItemsToHardware.apply((Object)items);
        }
    }
}

