/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.Password;

public class OperatingSystem {
    private final int id;
    private final Set<Password> passwords;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromOperatingSystem(this);
    }

    @ConstructorProperties(value={"id", "passwords"})
    protected OperatingSystem(int id, @Nullable Set<Password> passwords) {
        this.id = id;
        this.passwords = passwords == null ? ImmutableSet.of() : ImmutableSet.copyOf(passwords);
    }

    public int getId() {
        return this.id;
    }

    public Set<Password> getPasswords() {
        return this.passwords;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OperatingSystem that = (OperatingSystem)OperatingSystem.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", this.id).add("passwords", this.passwords);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected int id;
        protected Set<Password> passwords = ImmutableSet.of();

        protected abstract T self();

        public T id(int id) {
            this.id = id;
            return this.self();
        }

        public T passwords(Set<Password> passwords) {
            this.passwords = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(passwords, (Object)"passwords")));
            return this.self();
        }

        public T passwords(Password ... in) {
            return this.passwords((Set<Password>)ImmutableSet.copyOf((Object[])in));
        }

        public OperatingSystem build() {
            return new OperatingSystem(this.id, this.passwords);
        }

        public T fromOperatingSystem(OperatingSystem in) {
            return ((Builder)this.id(in.getId())).passwords(in.getPasswords());
        }
    }
}

