/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.ProductItemCategory;
import org.jclouds.softlayer.domain.ProductItemPrice;

public class ProductItem {
    private final int id;
    private final String description;
    private final String units;
    private final Float capacity;
    private final Set<ProductItemPrice> prices;
    private final Set<ProductItemCategory> categories;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromProductItem(this);
    }

    @ConstructorProperties(value={"id", "description", "units", "capacity", "prices", "categories"})
    protected ProductItem(int id, @Nullable String description, @Nullable String units, @Nullable Float capacity, @Nullable Set<ProductItemPrice> prices, @Nullable Set<ProductItemCategory> categories) {
        this.id = id;
        this.description = description;
        this.units = units;
        this.capacity = capacity;
        this.prices = prices == null ? ImmutableSet.of() : ImmutableSet.copyOf(prices);
        this.categories = categories == null ? ImmutableSet.of() : ImmutableSet.copyOf(categories);
    }

    public int getId() {
        return this.id;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getUnits() {
        return this.units;
    }

    @Nullable
    public Float getCapacity() {
        return this.capacity;
    }

    public Set<ProductItemPrice> getPrices() {
        return this.prices;
    }

    public Set<ProductItemCategory> getCategories() {
        return this.categories;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProductItem that = (ProductItem)ProductItem.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", this.id).add("description", (Object)this.description).add("units", (Object)this.units).add("capacity", (Object)this.capacity).add("prices", this.prices).add("categories", this.categories);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected int id;
        protected String description;
        protected String units;
        protected Float capacity;
        protected Set<ProductItemPrice> prices = ImmutableSet.of();
        protected Set<ProductItemCategory> categories = ImmutableSet.of();

        protected abstract T self();

        public T id(int id) {
            this.id = id;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T units(String units) {
            this.units = units;
            return this.self();
        }

        public T capacity(Float capacity) {
            this.capacity = capacity;
            return this.self();
        }

        public T prices(Set<ProductItemPrice> prices) {
            this.prices = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(prices, (Object)"prices")));
            return this.self();
        }

        public T prices(ProductItemPrice ... in) {
            return this.prices((Set<ProductItemPrice>)ImmutableSet.copyOf((Object[])in));
        }

        public T categories(Set<ProductItemCategory> categories) {
            this.categories = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(categories, (Object)"categories")));
            return this.self();
        }

        public T categories(ProductItemCategory ... in) {
            return this.categories((Set<ProductItemCategory>)ImmutableSet.copyOf((Object[])in));
        }

        public ProductItem build() {
            return new ProductItem(this.id, this.description, this.units, this.capacity, this.prices, this.categories);
        }

        public T fromProductItem(ProductItem in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).description(in.getDescription())).units(in.getUnits())).capacity(in.getCapacity())).prices(in.getPrices())).categories(in.getCategories());
        }
    }
}

