/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.ecloud;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.trmk.ecloud.BaseTerremarkECloudAsyncClientTest;
import org.jclouds.trmk.ecloud.TerremarkECloudAsyncClient;
import org.jclouds.trmk.vcloud_0_8.domain.Protocol;
import org.jclouds.trmk.vcloud_0_8.functions.ParseTaskFromLocationHeader;
import org.jclouds.trmk.vcloud_0_8.options.AddInternetServiceOptions;
import org.jclouds.trmk.vcloud_0_8.options.AddNodeOptions;
import org.jclouds.trmk.vcloud_0_8.options.InstantiateVAppTemplateOptions;
import org.jclouds.trmk.vcloud_0_8.xml.CatalogHandler;
import org.jclouds.trmk.vcloud_0_8.xml.CustomizationParametersHandler;
import org.jclouds.trmk.vcloud_0_8.xml.InternetServiceHandler;
import org.jclouds.trmk.vcloud_0_8.xml.InternetServicesHandler;
import org.jclouds.trmk.vcloud_0_8.xml.KeyPairByNameHandler;
import org.jclouds.trmk.vcloud_0_8.xml.KeyPairHandler;
import org.jclouds.trmk.vcloud_0_8.xml.KeyPairsHandler;
import org.jclouds.trmk.vcloud_0_8.xml.NetworkHandler;
import org.jclouds.trmk.vcloud_0_8.xml.NodeHandler;
import org.jclouds.trmk.vcloud_0_8.xml.NodesHandler;
import org.jclouds.trmk.vcloud_0_8.xml.PublicIpAddressHandler;
import org.jclouds.trmk.vcloud_0_8.xml.VAppExtendedInfoHandler;
import org.jclouds.trmk.vcloud_0_8.xml.VAppHandler;
import org.jclouds.trmk.vcloud_0_8.xml.VDCHandler;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="TerremarkECloudAsyncClientTest")
public class TerremarkECloudAsyncClientTest
extends BaseTerremarkECloudAsyncClientTest<TerremarkECloudAsyncClient> {
    public void testListOrgs() {
        Assert.assertEquals((String)((TerremarkECloudAsyncClient)this.injector.getInstance(TerremarkECloudAsyncClient.class)).listOrgs().toString(), (String)ImmutableMap.of((Object)ORG_REF.getName(), (Object)ORG_REF).toString());
    }

    public void testNetwork() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"getNetwork", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdcItem/2")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/vdcItem/2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.network+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, NetworkHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDelete() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"deleteVApp", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://vcloud.safesecureweb.com/api/v0.8/vApp/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseTaskFromLocationHeader.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testFindNetworkInOrgVDCNamed() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"findNetworkInOrgVDCNamed", (Class[])new Class[]{String.class, String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"org", (Object)"vdc", (Object)"network"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/network/1990 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.network+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, NetworkHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testCatalog() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"getCatalog", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://catalog")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://catalog HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.catalog+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, CatalogHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetVDC() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"getVDC", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/vdc/1")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud/vdc/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vdc+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VDCHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testInstantiateVAppTemplateInVDCURI() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"instantiateVAppTemplateInVDC", (Class[])new Class[]{URI.class, URI.class, String.class, InstantiateVAppTemplateOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1"), (Object)URI.create("https://vcloud/vAppTemplate/3"), (Object)"name"));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud.safesecureweb.com/api/v0.8/vdc/1/action/instantiateVAppTemplate HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vApp+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/InstantiateVAppTemplateParams-test.xml")), "application/vnd.vmware.vcloud.instantiateVAppTemplateParams+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VAppHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testInstantiateVAppTemplateInVDCURIOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"instantiateVAppTemplateInVDC", (Class[])new Class[]{URI.class, URI.class, String.class, InstantiateVAppTemplateOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1"), (Object)URI.create("https://vcloud/vAppTemplate/3"), (Object)"name", (Object)InstantiateVAppTemplateOptions.Builder.processorCount((int)2).memory(512L).inGroup("group").withPassword("password").inRow("row").addNetworkConfig(new InstantiateVAppTemplateOptions.NetworkConfig(URI.create("http://network")))));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud.safesecureweb.com/api/v0.8/vdc/1/action/instantiateVAppTemplate HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vApp+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/InstantiateVAppTemplateParams-options-test.xml")), "application/vnd.vmware.vcloud.instantiateVAppTemplateParams+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VAppHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testActivatePublicIpInVDC() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"activatePublicIpInVDC", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud.safesecureweb.com/api/v0.8/publicIps/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.ecloud.publicIp+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, PublicIpAddressHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetAllInternetServices() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"getAllInternetServicesInVDC", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/internetServices/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.ecloud.internetServicesList+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, InternetServicesHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetInternetService() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"getInternetService", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/internetService/12")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud/extensions/internetService/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.ecloud.internetServicesList+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, InternetServiceHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeleteInternetService() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"deleteInternetService", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/internetService/12")));
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://vcloud/extensions/internetService/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testAddInternetServiceToExistingIp() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"addInternetServiceToExistingIp", (Class[])new Class[]{URI.class, String.class, Protocol.class, Integer.TYPE, AddInternetServiceOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/publicIp/12"), (Object)"name", (Object)Protocol.TCP, (Object)22));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud/extensions/publicIp/12/internetServices HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.ecloud.internetService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/CreateInternetService-test2.xml")).replace("vCloudExpressExtensions-1.6", "eCloudExtensions-2.8"), "application/vnd.tmrk.ecloud.internetService+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, InternetServiceHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testAddInternetServiceToExistingIpOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"addInternetServiceToExistingIp", (Class[])new Class[]{URI.class, String.class, Protocol.class, Integer.TYPE, AddInternetServiceOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/publicIp/12"), (Object)"name", (Object)Protocol.TCP, (Object)22, (Object)AddInternetServiceOptions.Builder.disabled().withDescription("yahoo").monitorDisabled()));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud/extensions/publicIp/12/internetServices HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.ecloud.internetService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/CreateInternetService-options-test.xml")).replace("vCloudExpressExtensions-1.6", "eCloudExtensions-2.8"), "application/vnd.tmrk.ecloud.internetService+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, InternetServiceHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testAddNode() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"addNode", (Class[])new Class[]{URI.class, String.class, String.class, Integer.TYPE, AddNodeOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/internetService/12"), (Object)"10.2.2.2", (Object)"name", (Object)22));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud/extensions/internetService/12/nodeServices HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.nodeService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/CreateNodeService-test2.xml")).replace("vCloudExpressExtensions-1.6", "eCloudExtensions-2.8"), "application/vnd.tmrk.vCloud.nodeService+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, NodeHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testAddNodeOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"addNode", (Class[])new Class[]{URI.class, String.class, String.class, Integer.TYPE, AddNodeOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/internetService/12"), (Object)"10.2.2.2", (Object)"name", (Object)22, (Object)AddNodeOptions.Builder.disabled().withDescription("yahoo")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud/extensions/internetService/12/nodeServices HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.nodeService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/CreateNodeService-options-test.xml")).replace("vCloudExpressExtensions-1.6", "eCloudExtensions-2.8"), "application/vnd.tmrk.vCloud.nodeService+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, NodeHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetKeyPairInOrg() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"findKeyPairInOrg", (Class[])new Class[]{URI.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/org/1"), (Object)"keyPair"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/keysList/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.ecloud.keysList+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, KeyPairByNameHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testConfigureNodeWithDescription() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"configureNode", (Class[])new Class[]{URI.class, String.class, Boolean.TYPE, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/nodeService/12"), (Object)"name", (Object)true, (Object)"eggs"));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://vcloud/extensions/nodeService/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.nodeService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, "<NodeService xmlns=\"urn:tmrk:eCloudExtensions-2.8\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Name>name</Name><Enabled>true</Enabled><Description>eggs</Description></NodeService>", "application/vnd.tmrk.vCloud.nodeService+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, NodeHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testConfigureNodeNoDescription() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"configureNode", (Class[])new Class[]{URI.class, String.class, Boolean.TYPE, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{URI.create("https://vcloud/extensions/nodeService/12"), "name", true, null}));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://vcloud/extensions/nodeService/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.nodeService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, "<NodeService xmlns=\"urn:tmrk:eCloudExtensions-2.8\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Name>name</Name><Enabled>true</Enabled></NodeService>", "application/vnd.tmrk.vCloud.nodeService+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, NodeHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetNodes() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"getNodes", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/internetService/12")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud/extensions/internetService/12/nodeServices HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.nodeService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, NodesHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeleteNode() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"deleteNode", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/nodeService/12")));
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://vcloud/extensions/nodeService/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetCustomizationOptionsOfCatalogItem() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"getCustomizationOptions", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/template/12")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud/extensions/template/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.catalogItemCustomizationParameters+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, CustomizationParametersHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testListKeyPairsInOrg() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"listKeyPairsInOrg", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/org/1")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/keysList/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.ecloud.keysList+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, KeyPairsHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testListKeyPairsInOrgNotFound() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"listKeyPairsInOrg", (Class[])new Class[]{URI.class});
        this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("d")));
    }

    public void testGetKeyPair() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"getKeyPair", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/key/12")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud/extensions/key/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, KeyPairHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeleteKeyPair() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"deleteKeyPair", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/key/12")));
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://vcloud/extensions/key/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetNode() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"getNode", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/nodeService/12")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud/extensions/nodeService/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.nodeService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, NodeHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetExtendedInfo() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkECloudAsyncClient.class, (String)"getVAppExtendedInfo", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/vapp/12")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud/extensions/vapp/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.ecloud.vApp+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VAppExtendedInfoHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }
}

