/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloudexpress;

import com.google.common.collect.Sets;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.rest.RestContext;
import org.jclouds.trmk.vcloud_0_8.domain.InternetService;
import org.jclouds.trmk.vcloud_0_8.domain.Node;
import org.jclouds.trmk.vcloud_0_8.domain.PublicIpAddress;
import org.jclouds.trmk.vcloudexpress.TerremarkVCloudExpressApiMetadata;
import org.jclouds.trmk.vcloudexpress.TerremarkVCloudExpressClient;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="InternetServiceLiveTest")
public class InternetServiceLiveTest
extends BaseComputeServiceContextLiveTest {
    TerremarkVCloudExpressClient tmClient;
    private Set<InternetService> services = Sets.newLinkedHashSet();
    public static final String PREFIX = System.getProperty("user.name") + "-terremark";

    public InternetServiceLiveTest() {
        this.provider = "trmk-vcloudexpress";
    }

    @Test
    public void testGetAllInternetServices() throws Exception {
        this.tmClient.getAllInternetServicesInVDC(this.tmClient.findVDCInOrgNamed(null, null).getHref());
    }

    private void delete(Set<InternetService> set) {
        HashSet publicIps = Sets.newHashSet();
        for (InternetService service : set) {
            for (Node node : this.tmClient.getNodes(service.getId())) {
                this.tmClient.deleteNode(node.getId());
            }
            this.tmClient.deleteInternetService(service.getId());
            publicIps.add(service.getPublicIpAddress().getId());
        }
        for (URI id : publicIps) {
            this.tmClient.deletePublicIp(id);
        }
    }

    @Test
    public void testGetAllPublicIps() throws Exception {
        for (PublicIpAddress ip : this.tmClient.getPublicIpsAssociatedWithVDC(this.tmClient.findVDCInOrgNamed(null, null).getHref())) {
            this.tmClient.getInternetServicesOnPublicIp(ip.getId());
        }
    }

    @AfterTest
    void cleanup() throws InterruptedException, ExecutionException, TimeoutException {
        this.delete(this.services);
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.tmClient = (TerremarkVCloudExpressClient)((RestContext)((ComputeServiceContext)this.view).unwrap(TerremarkVCloudExpressApiMetadata.CONTEXT_TOKEN)).getApi();
    }

    void print(Set<InternetService> set) {
        for (InternetService service : set) {
            System.out.printf("%d (%s:%d%n)", service.getName(), service.getPublicIpAddress().getAddress(), service.getPort());
            for (Node node : this.tmClient.getNodes(service.getId())) {
                System.out.printf("   %d (%s:%d%n)", node.getName(), node.getIpAddress(), node.getPort());
            }
        }
    }
}

