/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloudexpress.compute;

import com.google.common.collect.ImmutableMap;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.internal.BaseComputeServiceLiveTest;
import org.jclouds.domain.Credentials;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.jclouds.trmk.vcloud_0_8.domain.VApp;
import org.jclouds.trmk.vcloudexpress.TerremarkVCloudExpressClient;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, enabled=true, singleThreaded=true)
public class TerremarkVCloudExpressComputeServiceLiveTest
extends BaseComputeServiceLiveTest {
    public TerremarkVCloudExpressComputeServiceLiveTest() {
        this.provider = "trmk-vcloudexpress";
    }

    public void setServiceDefaults() {
        this.group = "vcx";
    }

    protected Template buildTemplate(TemplateBuilder templateBuilder) {
        Template template = super.buildTemplate(templateBuilder);
        Image image = template.getImage();
        assert (image.getDefaultCredentials().identity != null) : image;
        assert (image.getDefaultCredentials().credential != null) : image;
        return template;
    }

    protected void tryBadPassword(String group, Credentials good) throws AssertionError {
    }

    protected void checkUserMetadataContains(NodeMetadata node, ImmutableMap<String, String> userMetadata) {
        assert (node.getUserMetadata().equals(ImmutableMap.of())) : String.format("node userMetadata did not match %s %s", userMetadata, node);
    }

    public void testListImages() throws Exception {
        for (Image image : this.client.listImages()) {
            assert (image.getProviderId() != null) : image;
            Assert.assertEquals((Object)image.getType(), (Object)ComputeType.IMAGE);
            assert (image.getDefaultCredentials().identity != null) : image;
            if (image.getOperatingSystem().getFamily() != OsFamily.WINDOWS) assert (image.getDefaultCredentials().credential != null) : image;
        }
    }

    public void testListNodes() throws Exception {
        for (ComputeMetadata node : this.client.listNodes()) {
            assert (node.getProviderId() != null);
            assert (node.getLocation() != null);
            Assert.assertEquals((Object)node.getType(), (Object)ComputeType.NODE);
            NodeMetadata allData = this.client.getNodeMetadata(node.getId());
            System.out.println(allData.getHardware());
            TerremarkVCloudExpressClient api = (TerremarkVCloudExpressClient)((ComputeServiceContext)this.view).utils().injector().getInstance(TerremarkVCloudExpressClient.class);
            VApp vApp = api.findVAppInOrgVDCNamed(null, null, allData.getName());
            Assert.assertEquals((String)vApp.getName(), (String)allData.getName());
        }
    }

    public void testDestroyNodes() {
        super.testDestroyNodes();
    }

    protected SshjSshClientModule getSshModule() {
        return new SshjSshClientModule();
    }
}

