/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.features;

import javax.ws.rs.core.Response;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.ultradns.ws.UltraDNSWSApi;
import org.jclouds.ultradns.ws.domain.DirectionalGroupCoordinates;
import org.jclouds.ultradns.ws.internal.BaseUltraDNSWSApiExpectTest;
import org.jclouds.ultradns.ws.parse.GetAccountLevelDirectionalGroupsResponseTest;
import org.jclouds.ultradns.ws.parse.GetAvailableGroupsResponseTest;
import org.jclouds.ultradns.ws.parse.GetDirectionalDNSGroupDetailsResponseTest;
import org.jclouds.ultradns.ws.parse.GetDirectionalDNSRecordsForHostResponseTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DirectionalGroupApiExpectTest")
public class DirectionalGroupApiExpectTest
extends BaseUltraDNSWSApiExpectTest {
    HttpRequest listGroupNamesByRecordNameAndType = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/list_directionalgroup_names.xml", "application/xml"))).build();
    HttpResponse listGroupNamesByRecordNameAndTypeResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/directionalgroup_names.xml", "application/xml"))).build();
    HttpRequest listRecordsByGroupCoordinates = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/list_directionalgroup_records.xml", "application/xml"))).build();
    HttpResponse listRecordsByGroupCoordinatesResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/directionalrecords.xml", "application/xml"))).build();
    HttpRequest get = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/get_directionalgroup.xml", "application/xml"))).build();
    HttpResponse getResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/directionalgroup.xml", "application/xml"))).build();
    HttpRequest listAccountLevelGroups = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/list_accountlevelgroups.xml", "application/xml"))).build();
    HttpResponse listAccountLevelGroupsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/accountlevelgroups.xml", "application/xml"))).build();
    HttpRequest listRecordsByAccountLevelGroup = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/list_accountlevelgroup_records.xml", "application/xml"))).build();
    HttpResponse listRecordsByAccountLevelGroupResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/directionalrecords.xml", "application/xml"))).build();

    public void testListGroupNamesByRecordNameAndTypeWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.listGroupNamesByRecordNameAndType, this.listGroupNamesByRecordNameAndTypeResponse);
        Assert.assertEquals((String)success.getDirectionalGroupApiForAccount("accountid").listGroupNamesByDNameAndType("www.jclouds.org.", 1).toString(), (String)new GetAvailableGroupsResponseTest().expected().toString());
    }

    public void testListRecordsByGroupCoordinatesWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.listRecordsByGroupCoordinates, this.listRecordsByGroupCoordinatesResponse);
        DirectionalGroupCoordinates group = DirectionalGroupCoordinates.builder().zoneName("jclouds.org.").recordName("www.jclouds.org.").recordType(1).groupName("EU-www.jclouds.org.").build();
        Assert.assertEquals((String)success.getDirectionalGroupApiForAccount("accountid").listRecordsByGroupCoordinates(group).toString(), (String)new GetDirectionalDNSRecordsForHostResponseTest().expected().toString());
    }

    public void testGetWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.get, this.getResponse);
        Assert.assertEquals((String)success.getDirectionalGroupApiForAccount("accountid").get("0000000000A").toString(), (String)new GetDirectionalDNSGroupDetailsResponseTest().expected().toString());
    }

    public void testListAccountLevelGroupsWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.listAccountLevelGroups, this.listAccountLevelGroupsResponse);
        Assert.assertEquals((String)success.getDirectionalGroupApiForAccount("accountid").listAccountLevelGroups().toString(), (String)new GetAccountLevelDirectionalGroupsResponseTest().expected().toString());
    }

    public void testListRecordsByAccountLevelGroupWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.listRecordsByAccountLevelGroup, this.listRecordsByAccountLevelGroupResponse);
        Assert.assertEquals((String)success.getDirectionalGroupApiForAccount("accountid").listRecordsByAccountLevelGroup("000000000000000A").toString(), (String)new GetDirectionalDNSRecordsForHostResponseTest().expected().toString());
    }
}

