/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.features;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Set;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.ultradns.ws.UltraDNSWSApi;
import org.jclouds.ultradns.ws.domain.AccountLevelGroup;
import org.jclouds.ultradns.ws.domain.DirectionalGroup;
import org.jclouds.ultradns.ws.domain.DirectionalGroupCoordinates;
import org.jclouds.ultradns.ws.domain.DirectionalPool;
import org.jclouds.ultradns.ws.domain.DirectionalPoolRecordDetail;
import org.jclouds.ultradns.ws.domain.Zone;
import org.jclouds.ultradns.ws.features.DirectionalGroupApi;
import org.jclouds.ultradns.ws.features.DirectionalPoolApiLiveTest;
import org.jclouds.ultradns.ws.internal.BaseUltraDNSWSApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="DirectionalGroupApiLiveTest")
public class DirectionalGroupApiLiveTest
extends BaseUltraDNSWSApiLiveTest {
    Set<DirectionalGroupCoordinates> allGroups = Sets.newLinkedHashSet();

    @Test
    public void testListAccountLevelGroups() {
        for (AccountLevelGroup group : this.api().listAccountLevelGroups()) {
            this.checkGroup(group);
        }
    }

    private void checkGroup(AccountLevelGroup group) {
        Assert.assertNotNull((Object)group.getId(), (String)("Id cannot be null " + group));
        Assert.assertNotNull((Object)group.getName(), (String)("Name cannot be null " + group));
        Assert.assertNotNull((Object)group.getType(), (String)("Type cannot be null " + group));
        Assert.assertTrue((group.getRecordCount() >= 0 ? 1 : 0) != 0, (String)("RecordCount must be positive " + group));
    }

    @Test
    public void testListRecordsByAccountLevelGroup() {
        for (AccountLevelGroup group : this.api().listAccountLevelGroups()) {
            for (DirectionalPoolRecordDetail rr : this.api().listRecordsByAccountLevelGroup(group.getId())) {
                DirectionalPoolApiLiveTest.checkDirectionalRecordDetail(rr);
            }
        }
    }

    @Test
    public void testGetDirectionalGroup() {
        for (AccountLevelGroup group : this.api().listAccountLevelGroups()) {
            DirectionalGroup withRegions = this.api().get(group.getId());
            Assert.assertEquals((String)withRegions.getName(), (String)group.getName());
            Assert.assertTrue((withRegions.size() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testListGroupNamesByRecordNameAndType() {
        for (Zone zone : ((UltraDNSWSApi)this.api).getZoneApi().listByAccount(this.account.getId())) {
            for (DirectionalPool pool : ((UltraDNSWSApi)this.api).getDirectionalPoolApiForZone(zone.getName()).list()) {
                for (DirectionalPool.RecordType type : EnumSet.allOf(DirectionalPool.RecordType.class)) {
                    for (String groupName : this.api().listGroupNamesByDNameAndType(pool.getDName(), type.getCode())) {
                        this.allGroups.add(DirectionalGroupCoordinates.builder().zoneName(zone.getName()).recordName(pool.getDName()).recordType(type.getCode()).groupName(groupName).build());
                    }
                }
            }
        }
    }

    @Test(dependsOnMethods={"testListGroupNamesByRecordNameAndType"})
    public void testListRecordsByGroupCoordinates() {
        for (DirectionalGroupCoordinates group : this.allGroups) {
            for (DirectionalPoolRecordDetail rr : this.api().listRecordsByGroupCoordinates(group)) {
                DirectionalPoolApiLiveTest.checkDirectionalRecordDetail(rr);
            }
        }
    }

    @Test(expectedExceptions={ResourceNotFoundException.class}, expectedExceptionsMessageRegExp="Group does not exist.")
    public void testListRecordsByAccountLevelGroupWhenGroupIdNotFound() {
        this.api().listRecordsByAccountLevelGroup("AAAAAAAAAAAAAAAA");
    }

    private DirectionalGroupApi api() {
        return ((UltraDNSWSApi)this.api).getDirectionalGroupApiForAccount(this.account.getId());
    }
}

