/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.features;

import com.google.common.collect.ImmutableSet;
import javax.ws.rs.core.Response;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.ultradns.ws.UltraDNSWSApi;
import org.jclouds.ultradns.ws.UltraDNSWSExceptions;
import org.jclouds.ultradns.ws.domain.DirectionalGroup;
import org.jclouds.ultradns.ws.domain.DirectionalPool;
import org.jclouds.ultradns.ws.domain.DirectionalPoolRecord;
import org.jclouds.ultradns.ws.internal.BaseUltraDNSWSApiExpectTest;
import org.jclouds.ultradns.ws.parse.GetDirectionalDNSRecordsForHostResponseTest;
import org.jclouds.ultradns.ws.parse.GetDirectionalPoolsByZoneResponseTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DirectionalPoolApiExpectTest")
public class DirectionalPoolApiExpectTest
extends BaseUltraDNSWSApiExpectTest {
    HttpRequest create = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/create_directionalpool.xml", "application/xml"))).build();
    HttpResponse createResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/directionalpool_created.xml", "application/xml"))).build();
    HttpResponse alreadyCreated = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResourceWithContentType("/directionalpool_already_exists.xml", "application/xml"))).build();
    HttpRequest addFirstRecordInNonConfiguredGroup = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/create_directionalrecord.xml", "application/xml"))).build();
    HttpResponse recordCreatedResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/directionalrecord_created.xml", "application/xml"))).build();
    DirectionalPoolRecord record = DirectionalPoolRecord.drBuilder().type("A").ttl(300).rdata((Object)"1.1.0.1").build();
    HttpResponse recordAlreadyCreated = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResourceWithContentType("/directionalrecord_already_exists.xml", "application/xml"))).build();
    HttpRequest addRecordIntoNewGroup = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/create_directionalrecord_newgroup.xml", "application/xml"))).build();
    DirectionalGroup group = DirectionalGroup.builder().name("Mexas").description("Clients we classify as being in US").mapRegionToTerritories("United States (US)", (Iterable)ImmutableSet.of((Object)"Maryland", (Object)"Texas")).build();
    HttpRequest addRecordIntoExistingGroup = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/create_directionalrecord_existinggroup.xml", "application/xml"))).build();
    HttpRequest updateRecord = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/update_directionalrecord.xml", "application/xml"))).build();
    HttpResponse updateRecordResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/directionalrecord_updated.xml", "application/xml"))).build();
    HttpResponse recordDoesntExist = ((HttpResponse.Builder)HttpResponse.builder().message("Server Error").statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResource("/directionalrecord_doesnt_exist.xml"))).build();
    HttpRequest updateRecordAndGroup = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/update_directionalrecord_group.xml", "application/xml"))).build();
    HttpRequest deleteRecord = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/delete_directionalrecord.xml", "application/xml"))).build();
    HttpResponse deleteRecordResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(404).payload(this.payloadFromResourceWithContentType("/directionalrecord_deleted.xml", "application/xml"))).build();
    HttpRequest list = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/list_directionalpools.xml", "application/xml"))).build();
    HttpResponse listResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/directionalpools.xml", "application/xml"))).build();
    HttpRequest listRecords = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/list_directionalrecords.xml", "application/xml"))).build();
    HttpResponse listRecordsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/directionalrecords.xml", "application/xml"))).build();

    public void testCreateWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.create, this.createResponse);
        Assert.assertEquals((String)success.getDirectionalPoolApiForZone("jclouds.org.").createForDNameAndType("foo", "www.jclouds.org.", DirectionalPool.RecordType.IPV4.getCode()), (String)"06063DC355055E68");
    }

    @Test(expectedExceptions={UltraDNSWSExceptions.ResourceAlreadyExistsException.class}, expectedExceptionsMessageRegExp="Pool already created for this host name : www.jclouds.org.")
    public void testCreateWhenResponseError2912() {
        UltraDNSWSApi already = (UltraDNSWSApi)this.requestSendsResponse(this.create, this.alreadyCreated);
        already.getDirectionalPoolApiForZone("jclouds.org.").createForDNameAndType("foo", "www.jclouds.org.", DirectionalPool.RecordType.IPV4.getCode());
    }

    public void testAddFirstRecordInNonConfiguredGroupWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.addFirstRecordInNonConfiguredGroup, this.recordCreatedResponse);
        Assert.assertEquals((String)success.getDirectionalPoolApiForZone("jclouds.org.").addFirstRecordInNonConfiguredGroup("06063DC355055E68", this.record), (String)"06063DC355058294");
    }

    @Test(expectedExceptions={UltraDNSWSExceptions.ResourceAlreadyExistsException.class}, expectedExceptionsMessageRegExp="Resource Record already exists.")
    public void testAddFirstRecordInNonConfiguredGroupWhenResponseError1802() {
        UltraDNSWSApi already = (UltraDNSWSApi)this.requestSendsResponse(this.addFirstRecordInNonConfiguredGroup, this.recordAlreadyCreated);
        already.getDirectionalPoolApiForZone("jclouds.org.").addFirstRecordInNonConfiguredGroup("06063DC355055E68", this.record);
    }

    public void testAddRecordIntoNewGroupWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.addRecordIntoNewGroup, this.recordCreatedResponse);
        Assert.assertEquals((String)success.getDirectionalPoolApiForZone("jclouds.org.").addRecordIntoNewGroup("06063DC355055E68", this.record, this.group), (String)"06063DC355058294");
    }

    public void testAddRecordIntoExistingGroupWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.addRecordIntoExistingGroup, this.recordCreatedResponse);
        Assert.assertEquals((String)success.getDirectionalPoolApiForZone("jclouds.org.").addRecordIntoExistingGroup("06063DC355055E68", this.record, "AAABBBCCCDDDEEE"), (String)"06063DC355058294");
    }

    public void testUpdateRecordWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.updateRecord, this.updateRecordResponse);
        success.getDirectionalPoolApiForZone("jclouds.org.").updateRecord("04053D8E57C7931F", this.record);
    }

    @Test(expectedExceptions={ResourceNotFoundException.class}, expectedExceptionsMessageRegExp="Directional Pool Record does not exist in the system")
    public void testUpdateRecordWhenResponseNotFound() {
        UltraDNSWSApi notFound = (UltraDNSWSApi)this.requestSendsResponse(this.updateRecord, this.recordDoesntExist);
        notFound.getDirectionalPoolApiForZone("jclouds.org.").updateRecord("04053D8E57C7931F", this.record);
    }

    public void testUpdateRecordAndGroupWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.updateRecordAndGroup, this.updateRecordResponse);
        success.getDirectionalPoolApiForZone("jclouds.org.").updateRecordAndGroup("04053D8E57C7931F", this.record, this.group);
    }

    public void testDeleteRecordWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.deleteRecord, this.deleteRecordResponse);
        success.getDirectionalPoolApiForZone("jclouds.org.").deleteRecord("04053D8E57C7931F");
    }

    public void testDeleteRecordWhenResponseNotFound() {
        UltraDNSWSApi notFound = (UltraDNSWSApi)this.requestSendsResponse(this.deleteRecord, this.recordDoesntExist);
        notFound.getDirectionalPoolApiForZone("jclouds.org.").deleteRecord("04053D8E57C7931F");
    }

    public void testListWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.list, this.listResponse);
        Assert.assertEquals((String)success.getDirectionalPoolApiForZone("jclouds.org.").list().toString(), (String)new GetDirectionalPoolsByZoneResponseTest().expected().toString());
    }

    public void testListRecordsWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.listRecords, this.listRecordsResponse);
        Assert.assertEquals((String)success.getDirectionalPoolApiForZone("jclouds.org.").listRecordsByDNameAndType("www.jclouds.org.", 1).toString(), (String)new GetDirectionalDNSRecordsForHostResponseTest().expected().toString());
    }
}

