/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.features;

import javax.ws.rs.core.Response;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.ultradns.ws.UltraDNSWSApi;
import org.jclouds.ultradns.ws.UltraDNSWSExceptions;
import org.jclouds.ultradns.ws.domain.ResourceRecord;
import org.jclouds.ultradns.ws.internal.BaseUltraDNSWSApiExpectTest;
import org.jclouds.ultradns.ws.parse.GetResourceRecordsOfResourceRecordResponseTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ResourceRecordApiExpectTest")
public class ResourceRecordApiExpectTest
extends BaseUltraDNSWSApiExpectTest {
    HttpRequest create = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/create_rr.xml", "application/xml"))).build();
    HttpResponse createResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/rr_created.xml", "application/xml"))).build();
    ResourceRecord record = ResourceRecord.rrBuilder().name("mail.jclouds.org.").type(15).ttl(1800).infoValue((Object)10).infoValue((Object)"maileast.jclouds.org.").build();
    HttpResponse alreadyCreated = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResourceWithContentType("/rr_already_exists.xml", "application/xml"))).build();
    HttpRequest update = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/update_rr.xml", "application/xml"))).build();
    HttpResponse updateResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/rr_updated.xml", "application/xml"))).build();
    HttpRequest list = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/list_records.xml", "application/xml"))).build();
    HttpResponse listResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/records.xml", "application/xml"))).build();
    HttpResponse zoneDoesntExist = ((HttpResponse.Builder)HttpResponse.builder().message("Server Error").statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResource("/zone_doesnt_exist.xml"))).build();
    HttpRequest listByName = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/list_records_by_name.xml", "application/xml"))).build();
    HttpRequest listByNameAndType = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/list_records_by_name_and_type.xml", "application/xml"))).build();
    HttpRequest delete = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/delete_rr.xml", "application/xml"))).build();
    HttpResponse deleteResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(404).payload(this.payloadFromResourceWithContentType("/rr_deleted.xml", "application/xml"))).build();
    HttpResponse rrDoesntExist = ((HttpResponse.Builder)HttpResponse.builder().message("Server Error").statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResource("/rr_doesnt_exist.xml"))).build();

    public void testCreateWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.create, this.createResponse);
        success.getResourceRecordApiForZone("jclouds.org.").create(this.record);
    }

    @Test(expectedExceptions={UltraDNSWSExceptions.ResourceAlreadyExistsException.class}, expectedExceptionsMessageRegExp="Resource Record of type 15 with these attributes already exists in the system.")
    public void testCreateWhenResponseError1802() {
        UltraDNSWSApi already = (UltraDNSWSApi)this.requestSendsResponse(this.create, this.alreadyCreated);
        already.getResourceRecordApiForZone("jclouds.org.").create(this.record);
    }

    public void testUpdateWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.update, this.updateResponse);
        success.getResourceRecordApiForZone("jclouds.org.").update("04053D8E57C7931F", this.record);
    }

    public void testListWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.list, this.listResponse);
        Assert.assertEquals((String)success.getResourceRecordApiForZone("jclouds.org.").list().toString(), (String)new GetResourceRecordsOfResourceRecordResponseTest().expected().toString());
    }

    @Test(expectedExceptions={ResourceNotFoundException.class}, expectedExceptionsMessageRegExp="Zone does not exist in the system.")
    public void testListWhenResponseError1801() {
        UltraDNSWSApi notFound = (UltraDNSWSApi)this.requestSendsResponse(this.list, this.zoneDoesntExist);
        notFound.getResourceRecordApiForZone("jclouds.org.").list();
    }

    public void testListByNameWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.listByName, this.listResponse);
        Assert.assertEquals((String)success.getResourceRecordApiForZone("jclouds.org.").listByName("www.jclouds.org.").toString(), (String)new GetResourceRecordsOfResourceRecordResponseTest().expected().toString());
    }

    public void testListByNameAndTypeWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.listByNameAndType, this.listResponse);
        Assert.assertEquals((String)success.getResourceRecordApiForZone("jclouds.org.").listByNameAndType("www.jclouds.org.", 1).toString(), (String)new GetResourceRecordsOfResourceRecordResponseTest().expected().toString());
        Assert.assertEquals((String)success.getResourceRecordApiForZone("jclouds.org.").listByNameAndType("www.jclouds.org.", 1).toString(), (String)new GetResourceRecordsOfResourceRecordResponseTest().expected().toString());
    }

    public void testDeleteWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.delete, this.deleteResponse);
        success.getZoneApi().delete("04053D8E57C7931F");
    }

    public void testDeleteWhenResponseRRNotFound() {
        UltraDNSWSApi notFound = (UltraDNSWSApi)this.requestSendsResponse(this.delete, this.rrDoesntExist);
        notFound.getZoneApi().delete("04053D8E57C7931F");
    }
}

