/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.features;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import java.util.logging.Logger;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.ultradns.ws.UltraDNSWSApi;
import org.jclouds.ultradns.ws.UltraDNSWSExceptions;
import org.jclouds.ultradns.ws.domain.ResourceRecord;
import org.jclouds.ultradns.ws.domain.ResourceRecordDetail;
import org.jclouds.ultradns.ws.domain.RoundRobinPool;
import org.jclouds.ultradns.ws.domain.Zone;
import org.jclouds.ultradns.ws.features.ResourceRecordApiLiveTest;
import org.jclouds.ultradns.ws.features.RoundRobinPoolApi;
import org.jclouds.ultradns.ws.internal.BaseUltraDNSWSApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="RoundRobinPoolApiLiveTest")
public class RoundRobinPoolApiLiveTest
extends BaseUltraDNSWSApiLiveTest {
    String dname;
    String aPoolId;
    String aRecord1;
    String aRecord2;
    private String aaaaPoolId;
    String aaaaRecord1;
    String aaaaRecord2;

    public RoundRobinPoolApiLiveTest() {
        this.dname = "www.rrpool." + this.zoneName;
    }

    @Override
    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.createZone();
    }

    private void checkRRPool(RoundRobinPool pool) {
        Assert.assertNotNull((Object)pool.getZoneId(), (String)("ZoneId cannot be null for " + pool));
        Assert.assertNotNull((Object)pool.getId(), (String)("Id cannot be null for " + pool));
        Assert.assertNotNull((Object)pool.getName(), (String)("Name cannot be null for " + pool));
        Assert.assertNotNull((Object)pool.getDName(), (String)("DName cannot be null for " + pool));
    }

    @Test
    public void testListRRPools() {
        for (Zone zone : ((UltraDNSWSApi)this.api).getZoneApi().listByAccount(this.account.getId())) {
            for (RoundRobinPool pool : this.api(zone.getName()).list()) {
                this.checkRRPool(pool);
            }
        }
    }

    @Test
    public void testListRRPoolRecords() {
        for (Zone zone : ((UltraDNSWSApi)this.api).getZoneApi().listByAccount(this.account.getId())) {
            for (RoundRobinPool pool : this.api(zone.getName()).list()) {
                for (ResourceRecordDetail record : this.api(zone.getName()).listRecords(pool.getId())) {
                    ResourceRecordApiLiveTest.checkResourceRecordMetadata(record);
                }
            }
        }
    }

    @Test(expectedExceptions={ResourceNotFoundException.class}, expectedExceptionsMessageRegExp="Zone does not exist in the system.")
    public void testListRRPoolsWhenZoneIdNotFound() {
        this.api("AAAAAAAAAAAAAAAA").list();
    }

    @Test
    public void testDeleteWhenNotFound() {
        this.api(this.zoneName).delete("06063D9C54C5AE09");
    }

    @Test
    public void testCreateAPool() {
        this.aPoolId = this.api(this.zoneName).createForDNameAndType("A pool", this.dname, RoundRobinPool.RecordType.A.getCode());
        Logger.getAnonymousLogger().info("created A rr pool: " + this.aPoolId);
        try {
            this.api(this.zoneName).createForDNameAndType("A pool", this.dname, RoundRobinPool.RecordType.A.getCode());
            Assert.fail();
        }
        catch (UltraDNSWSExceptions.ResourceAlreadyExistsException e) {
            // empty catch block
        }
        Optional<RoundRobinPool> aPool = this.getPoolById(this.aPoolId);
        Assert.assertTrue((boolean)aPool.isPresent());
        Assert.assertEquals((String)((RoundRobinPool)aPool.get()).getName(), (String)"A pool");
        Assert.assertEquals((String)((RoundRobinPool)aPool.get()).getDName(), (String)this.dname);
    }

    @Test(dependsOnMethods={"testCreateAPool"})
    public void addARecordToPool() {
        this.aRecord1 = this.api(this.zoneName).addARecordWithAddressAndTTL(this.aPoolId, "1.2.3.4", 1);
        Logger.getAnonymousLogger().info("created A record: " + this.aRecord1);
        Assert.assertTrue((boolean)this.listRRs(this.aPoolId).anyMatch(Predicates.equalTo((Object)ResourceRecord.rrBuilder().name(this.dname).type(1).ttl(1).rdata((Object)"1.2.3.4").build())));
        this.aRecord2 = this.api(this.zoneName).addARecordWithAddressAndTTL(this.aPoolId, "3.4.5.6", 1);
        Assert.assertTrue((boolean)this.listRRs(this.aPoolId).anyMatch(Predicates.equalTo((Object)ResourceRecord.rrBuilder().name(this.dname).type(1).ttl(1).rdata((Object)"3.4.5.6").build())));
        Logger.getAnonymousLogger().info("created A record: " + this.aRecord1);
        try {
            this.api(this.zoneName).addARecordWithAddressAndTTL(this.aPoolId, "1.2.3.4", 1);
            Assert.fail();
        }
        catch (UltraDNSWSExceptions.ResourceAlreadyExistsException resourceAlreadyExistsException) {
            // empty catch block
        }
    }

    @Test(dependsOnMethods={"addARecordToPool"})
    public void testUpdateRecord() {
        this.api(this.zoneName).updateRecordWithAddressAndTTL(this.aPoolId, this.aRecord1, "1.1.1.1", 0);
        Assert.assertTrue((boolean)this.listRRs(this.aPoolId).anyMatch(Predicates.equalTo((Object)ResourceRecord.rrBuilder().name(this.dname).type(1).ttl(0).rdata((Object)"1.1.1.1").build())));
    }

    @Test(dependsOnMethods={"testUpdateRecord"})
    public void testDeleteRecord() {
        this.api(this.zoneName).deleteRecord(this.aRecord2);
        Assert.assertTrue((boolean)this.listRRs(this.aPoolId).anyMatch(Predicates.equalTo((Object)ResourceRecord.rrBuilder().name(this.dname).type(1).ttl(0).rdata((Object)"1.1.1.1").build())));
        Assert.assertFalse((boolean)this.listRRs(this.aPoolId).anyMatch(Predicates.equalTo((Object)ResourceRecord.rrBuilder().name(this.dname).type(1).ttl(1).rdata((Object)"3.4.5.6").build())));
    }

    @Test(dependsOnMethods={"testDeleteRecord"})
    public void testDeleteAPool() {
        this.api(this.zoneName).delete(this.aPoolId);
        Assert.assertFalse((boolean)this.getPoolById(this.aPoolId).isPresent());
    }

    @Test
    public void testCreateAAAAPool() {
        this.aaaaPoolId = this.api(this.zoneName).createForDNameAndType("AAAA pool", this.dname, RoundRobinPool.RecordType.AAAA.getCode());
        Logger.getAnonymousLogger().info("created AAAA rr pool: " + this.aaaaPoolId);
        try {
            this.api(this.zoneName).createForDNameAndType("AAAA pool", this.dname, RoundRobinPool.RecordType.AAAA.getCode());
            Assert.fail();
        }
        catch (UltraDNSWSExceptions.ResourceAlreadyExistsException e) {
            // empty catch block
        }
        Optional<RoundRobinPool> aPool = this.getPoolById(this.aaaaPoolId);
        Assert.assertTrue((boolean)aPool.isPresent());
        Assert.assertEquals((String)((RoundRobinPool)aPool.get()).getName(), (String)"AAAA pool");
        Assert.assertEquals((String)((RoundRobinPool)aPool.get()).getDName(), (String)this.dname);
    }

    @Test(dependsOnMethods={"testCreateAAAAPool"})
    public void addAAAARecordToPool() {
        this.aaaaRecord1 = this.api(this.zoneName).addAAAARecordWithAddressAndTTL(this.aaaaPoolId, "2001:0DB8:85A3:0000:0000:8A2E:0370:7334", 1);
        Logger.getAnonymousLogger().info("created AAAA record: " + this.aaaaRecord1);
        Assert.assertTrue((boolean)this.listRRs(this.aaaaPoolId).anyMatch(Predicates.equalTo((Object)ResourceRecord.rrBuilder().name(this.dname).type(28).ttl(1).rdata((Object)"2001:0DB8:85A3:0000:0000:8A2E:0370:7334").build())));
        this.aaaaRecord2 = this.api(this.zoneName).addAAAARecordWithAddressAndTTL(this.aaaaPoolId, "2002:0DB8:85A3:0000:0000:8A2E:0370:7334", 1);
        Assert.assertTrue((boolean)this.listRRs(this.aaaaPoolId).anyMatch(Predicates.equalTo((Object)ResourceRecord.rrBuilder().name(this.dname).type(28).ttl(1).rdata((Object)"2002:0DB8:85A3:0000:0000:8A2E:0370:7334").build())));
        Logger.getAnonymousLogger().info("created AAAA record: " + this.aaaaRecord1);
        try {
            this.api(this.zoneName).addAAAARecordWithAddressAndTTL(this.aaaaPoolId, "2001:0DB8:85A3:0000:0000:8A2E:0370:7334", 1);
            Assert.fail();
        }
        catch (UltraDNSWSExceptions.ResourceAlreadyExistsException resourceAlreadyExistsException) {
            // empty catch block
        }
    }

    @Test(dependsOnMethods={"addAAAARecordToPool"})
    public void testDeleteAAAAPool() {
        this.api(this.zoneName).delete(this.aaaaPoolId);
        Assert.assertFalse((boolean)this.getPoolById(this.aaaaPoolId).isPresent());
    }

    protected Optional<RoundRobinPool> getPoolById(final String poolId) {
        return this.api(this.zoneName).list().firstMatch((Predicate)new Predicate<RoundRobinPool>(){

            public boolean apply(RoundRobinPool in) {
                return in.getId().equals(poolId);
            }
        });
    }

    private FluentIterable<ResourceRecord> listRRs(String poolId) {
        return this.api(this.zoneName).listRecords(poolId).transform(ResourceRecordApiLiveTest.toRecord);
    }

    private RoundRobinPoolApi api(String zoneName) {
        return ((UltraDNSWSApi)this.api).getRoundRobinPoolApiForZone(zoneName);
    }
}

