/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.features;

import javax.ws.rs.core.Response;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.ultradns.ws.UltraDNSWSApi;
import org.jclouds.ultradns.ws.internal.BaseUltraDNSWSApiExpectTest;
import org.jclouds.ultradns.ws.parse.GetAllTasksResponseTest;
import org.jclouds.ultradns.ws.parse.GetStatusForTaskResponseResponseTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="TaskApiExpectTest")
public class TaskApiExpectTest
extends BaseUltraDNSWSApiExpectTest {
    HttpRequest runTest = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/run_test.xml", "application/xml"))).build();
    HttpResponse runTestResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/taskid.xml", "application/xml"))).build();
    HttpRequest get = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/get_task.xml", "application/xml"))).build();
    HttpResponse getResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/task.xml", "application/xml"))).build();
    HttpResponse taskDoesntExist = ((HttpResponse.Builder)HttpResponse.builder().message("Server Error").statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResource("/task_doesnt_exist.xml"))).build();
    HttpRequest clear = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/clear_task.xml", "application/xml"))).build();
    HttpResponse clearResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/task.xml", "application/xml"))).build();
    HttpRequest list = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/list_tasks.xml", "application/xml"))).build();
    HttpResponse listResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/tasks.xml", "application/xml"))).build();

    public void testRunTestWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.runTest, this.runTestResponse);
        Assert.assertEquals((String)success.getTaskApi().runTest("foo").toString(), (String)"8d7a1725-4f4a-4b70-affa-f01dcce1526e");
    }

    public void testGetWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.get, this.getResponse);
        Assert.assertEquals((String)success.getTaskApi().get("0b40c7dd-748d-4c49-8506-26f0c7d2ea9c").toString(), (String)new GetStatusForTaskResponseResponseTest().expected().toString());
    }

    public void testGetWhenResponseError2401() {
        UltraDNSWSApi notFound = (UltraDNSWSApi)this.requestSendsResponse(this.get, this.taskDoesntExist);
        Assert.assertNull((Object)notFound.getTaskApi().get("0b40c7dd-748d-4c49-8506-26f0c7d2ea9c"));
    }

    public void testClearWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.clear, this.clearResponse);
        success.getTaskApi().clear("0b40c7dd-748d-4c49-8506-26f0c7d2ea9c");
    }

    public void testClearWhenResponseError2401() {
        UltraDNSWSApi notFound = (UltraDNSWSApi)this.requestSendsResponse(this.clear, this.taskDoesntExist);
        notFound.getTaskApi().clear("0b40c7dd-748d-4c49-8506-26f0c7d2ea9c");
    }

    public void testListWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.list, this.listResponse);
        Assert.assertEquals((String)success.getTaskApi().list().toString(), (String)new GetAllTasksResponseTest().expected().toString());
    }
}

