/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.features;

import javax.ws.rs.core.Response;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.ultradns.ws.UltraDNSWSApi;
import org.jclouds.ultradns.ws.UltraDNSWSExceptions;
import org.jclouds.ultradns.ws.domain.Zone;
import org.jclouds.ultradns.ws.internal.BaseUltraDNSWSApiExpectTest;
import org.jclouds.ultradns.ws.parse.GetGeneralPropertiesForZoneResponseTest;
import org.jclouds.ultradns.ws.parse.GetZonesOfAccountResponseTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ZoneApiExpectTest")
public class ZoneApiExpectTest
extends BaseUltraDNSWSApiExpectTest {
    HttpRequest create = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/create_zone.xml", "application/xml"))).build();
    HttpResponse createResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/zone_created.xml", "application/xml"))).build();
    HttpResponse alreadyCreated = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResourceWithContentType("/zone_already_exists.xml", "application/xml"))).build();
    HttpRequest get = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/get_zone.xml", "application/xml"))).build();
    HttpResponse getResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/zoneproperties.xml", "application/xml"))).build();
    HttpResponse zoneDoesntExist = ((HttpResponse.Builder)HttpResponse.builder().message("Server Error").statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResource("/zone_doesnt_exist.xml"))).build();
    HttpRequest listByAccount = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/list_zones_by_account.xml", "application/xml"))).build();
    HttpResponse listByAccountResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/zones.xml", "application/xml"))).build();
    HttpResponse accountDoesntExist = ((HttpResponse.Builder)HttpResponse.builder().message("Server Error").statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResource("/account_doesnt_exist.xml"))).build();
    HttpRequest listByAccountAndType = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/list_zones_by_account_and_type.xml", "application/xml"))).build();
    HttpRequest delete = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/delete_zone.xml", "application/xml"))).build();
    HttpResponse deleteResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(404).payload(this.payloadFromResourceWithContentType("/zone_deleted.xml", "application/xml"))).build();

    public void testCreateWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.create, this.createResponse);
        success.getZoneApi().createInAccount("jclouds.org.", "AAAAAAAAAAAAAAAA");
    }

    @Test(expectedExceptions={UltraDNSWSExceptions.ResourceAlreadyExistsException.class}, expectedExceptionsMessageRegExp="Zone already exists in the system.")
    public void testCreateWhenResponseError1802() {
        UltraDNSWSApi already = (UltraDNSWSApi)this.requestSendsResponse(this.create, this.alreadyCreated);
        already.getZoneApi().createInAccount("jclouds.org.", "AAAAAAAAAAAAAAAA");
    }

    public void testGetWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.get, this.getResponse);
        Assert.assertEquals((String)success.getZoneApi().get("jclouds.org.").toString(), (String)new GetGeneralPropertiesForZoneResponseTest().expected().toString());
    }

    public void testGetWhenResponseError2401() {
        UltraDNSWSApi notFound = (UltraDNSWSApi)this.requestSendsResponse(this.get, this.zoneDoesntExist);
        Assert.assertNull((Object)notFound.getZoneApi().get("jclouds.org."));
    }

    public void testListByAccountWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.listByAccount, this.listByAccountResponse);
        Assert.assertEquals((String)success.getZoneApi().listByAccount("AAAAAAAAAAAAAAAA").toString(), (String)new GetZonesOfAccountResponseTest().expected().toString());
    }

    @Test(expectedExceptions={ResourceNotFoundException.class}, expectedExceptionsMessageRegExp="Account not found in the system. ID: AAAAAAAAAAAAAAAA")
    public void testListByAccountWhenResponseError2401() {
        UltraDNSWSApi notFound = (UltraDNSWSApi)this.requestSendsResponse(this.listByAccount, this.accountDoesntExist);
        notFound.getZoneApi().listByAccount("AAAAAAAAAAAAAAAA");
    }

    public void testListByAccountAndTypeWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.listByAccountAndType, this.listByAccountResponse);
        Assert.assertEquals((String)success.getZoneApi().listByAccountAndType("AAAAAAAAAAAAAAAA", Zone.Type.PRIMARY).toString(), (String)new GetZonesOfAccountResponseTest().expected().toString());
    }

    @Test(expectedExceptions={ResourceNotFoundException.class}, expectedExceptionsMessageRegExp="Account not found in the system. ID: AAAAAAAAAAAAAAAA")
    public void testListByAccountAndTypeWhenResponseError2401() {
        UltraDNSWSApi notFound = (UltraDNSWSApi)this.requestSendsResponse(this.listByAccountAndType, this.accountDoesntExist);
        notFound.getZoneApi().listByAccountAndType("AAAAAAAAAAAAAAAA", Zone.Type.PRIMARY);
    }

    public void testDeleteWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.delete, this.deleteResponse);
        success.getZoneApi().delete("jclouds.org.");
    }

    public void testDeleteWhenResponseError1801() {
        UltraDNSWSApi notFound = (UltraDNSWSApi)this.requestSendsResponse(this.delete, this.zoneDoesntExist);
        notFound.getZoneApi().delete("jclouds.org.");
    }
}

