/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.internal;

import com.google.common.base.CaseFormat;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import org.jclouds.apis.BaseApiLiveTest;
import org.jclouds.ultradns.ws.UltraDNSWSApi;
import org.jclouds.ultradns.ws.domain.IdAndName;
import org.jclouds.ultradns.ws.domain.Zone;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class BaseUltraDNSWSApiLiveTest
extends BaseApiLiveTest<UltraDNSWSApi> {
    protected String zoneName = String.format("%s-%s.ultradnstest.jclouds.org.", System.getProperty("user.name").replace('.', '-'), CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, ((Object)((Object)this)).getClass().getSimpleName()));
    protected String zoneId;
    protected IdAndName account;

    public BaseUltraDNSWSApiLiveTest() {
        this.provider = "ultradns-ws";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.account = ((UltraDNSWSApi)this.api).getCurrentAccount();
    }

    protected void createZone() {
        ((UltraDNSWSApi)this.api).getZoneApi().delete(this.zoneName);
        ((UltraDNSWSApi)this.api).getZoneApi().createInAccount(this.zoneName, this.account.getId());
        this.zoneId = ((Zone)this.getZoneByName(this.zoneName).get()).getId();
    }

    protected Optional<Zone> getZoneByName(final String zoneName) {
        return ((UltraDNSWSApi)this.api).getZoneApi().listByAccount(this.account.getId()).firstMatch((Predicate)new Predicate<Zone>(){

            public boolean apply(Zone in) {
                return in.getName().equals(zoneName);
            }
        });
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDown() {
        if (this.zoneId != null) {
            ((UltraDNSWSApi)this.api).getZoneApi().delete(this.zoneName);
        }
        super.tearDown();
    }
}

