/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.parse;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.net.URI;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.Task;
import org.jclouds.ultradns.ws.xml.TaskListHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="GetAllTasksResponseTest")
public class GetAllTasksResponseTest
extends BaseHandlerTest {
    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/tasks.xml");
        FluentIterable<Task> expected = this.expected();
        TaskListHandler handler = (TaskListHandler)this.injector.getInstance(TaskListHandler.class);
        FluentIterable result = (FluentIterable)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toSet().toString(), (String)expected.toSet().toString());
    }

    public FluentIterable<Task> expected() {
        return FluentIterable.from((Iterable)ImmutableSet.builder().add((Object)Task.builder().guid("0b40c7dd-748d-4c49-8506-26f0c7d2ea9c").statusCode(Task.StatusCode.COMPLETE).message("Processing complete").resultUrl(URI.create("http://localhost:8008/users/node01/tasks/0b40c7dd-748d-4c49-8506-26f0c7d2ea9c/result")).build()).build());
    }
}

