/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.parse;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.DirectionalPoolRecord;
import org.jclouds.ultradns.ws.domain.DirectionalPoolRecordDetail;
import org.jclouds.ultradns.ws.domain.IdAndName;
import org.jclouds.ultradns.ws.xml.DirectionalPoolRecordDetailListHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="GetDirectionalDNSRecordsForHostResponseTest")
public class GetDirectionalDNSRecordsForHostResponseTest
extends BaseHandlerTest {
    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/directionalrecords.xml");
        FluentIterable<DirectionalPoolRecordDetail> expected = this.expected();
        DirectionalPoolRecordDetailListHandler handler = (DirectionalPoolRecordDetailListHandler)this.injector.getInstance(DirectionalPoolRecordDetailListHandler.class);
        FluentIterable result = (FluentIterable)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toSet().toString(), (String)expected.toSet().toString());
    }

    public FluentIterable<DirectionalPoolRecordDetail> expected() {
        return FluentIterable.from((Iterable)ImmutableSet.builder().add((Object)DirectionalPoolRecordDetail.builder().zoneName("geo.jclouds.org.").name("www.geo.jclouds.org.").id("A000000000000001").geolocationGroup(IdAndName.create((String)"C000000000000001", (String)"southamerica")).record(DirectionalPoolRecord.drBuilder().type("CNAME").ttl(300).noResponseRecord(false).rdata((Object)"southamerica.geo.jclouds.org.").build()).build()).add((Object)DirectionalPoolRecordDetail.builder().zoneName("geo.jclouds.org.").name("www.geo.jclouds.org.").id("A000000000000002").group(IdAndName.create((String)"B000000000000001", (String)"All Non-Configured Regions")).record(DirectionalPoolRecord.drBuilder().type("A").ttl(500).noResponseRecord(false).rdata((Object)"1.1.1.2").build()).build()).add((Object)DirectionalPoolRecordDetail.builder().zoneName("geo.jclouds.org.").name("www.geo.jclouds.org.").id("A000000000000003").geolocationGroup(IdAndName.create((String)"C000000000000002", (String)"antarctica-unsupported")).record(DirectionalPoolRecord.drBuilder().type("A").ttl(0).noResponseRecord(true).rdata((Object)"No Data Response").build()).build()).add((Object)DirectionalPoolRecordDetail.builder().zoneName("geo.jclouds.org.").name("www.geo.jclouds.org.").id("A000000000000004").geolocationGroup(IdAndName.create((String)"C000000000000003", (String)"alazona")).record(DirectionalPoolRecord.drBuilder().type("A").ttl(86400).noResponseRecord(false).rdata((Object)"1.1.1.1").build()).build()).build());
    }
}

