/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.parse;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.DirectionalPool;
import org.jclouds.ultradns.ws.xml.DirectionalPoolListHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="GetDirectionalPoolsByZoneResponseTest")
public class GetDirectionalPoolsByZoneResponseTest
extends BaseHandlerTest {
    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/directionalpools.xml");
        FluentIterable<DirectionalPool> expected = this.expected();
        DirectionalPoolListHandler handler = (DirectionalPoolListHandler)this.injector.getInstance(DirectionalPoolListHandler.class);
        FluentIterable result = (FluentIterable)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toSet().toString(), (String)expected.toSet().toString());
    }

    public FluentIterable<DirectionalPool> expected() {
        return FluentIterable.from((Iterable)ImmutableList.builder().add((Object)DirectionalPool.builder().zoneId("0000000000000001").id("000000000000000A").dname("mixy.jclouds.org.").type(DirectionalPool.Type.MIXED).tieBreak(DirectionalPool.TieBreak.GEOLOCATION).name("mixy").build()).add((Object)DirectionalPool.builder().zoneId("0000000000000002").id("000000000000000B").dname("geo.jclouds.org.").build()).build());
    }
}

