/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.parse;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.ResourceRecord;
import org.jclouds.ultradns.ws.domain.ResourceRecordDetail;
import org.jclouds.ultradns.ws.xml.ResourceRecordListHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="GetResourceRecordsOfDNameByTypeResponseTest")
public class GetResourceRecordsOfDNameByTypeResponseTest
extends BaseHandlerTest {
    SimpleDateFormatDateService dateService = new SimpleDateFormatDateService();

    @Test
    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/records_by_name_and_type.xml");
        FluentIterable<ResourceRecordDetail> expected = this.expected();
        ResourceRecordListHandler handler = (ResourceRecordListHandler)this.injector.getInstance(ResourceRecordListHandler.class);
        FluentIterable result = (FluentIterable)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toList().toString(), (String)expected.toList().toString());
    }

    public FluentIterable<ResourceRecordDetail> expected() {
        ResourceRecordDetail record = ResourceRecordDetail.builder().zoneId("03053D8E57C7A22A").guid("04053D8E57C7A22F").zoneName("adrianc.rr.ultradnstest.jclouds.org.").created(this.dateService.iso8601DateParse("2013-02-22T08:22:48.000Z")).modified(this.dateService.iso8601DateParse("2013-02-22T08:22:49.000Z")).record(ResourceRecord.rrBuilder().name("adrianc.rr.ultradnstest.jclouds.org.").type(6).ttl(86400).infoValue((Object)"pdns75.ultradns.com.").infoValue((Object)"adrianc.netflix.com.").infoValue((Object)"2013022200").infoValue((Object)"86400").infoValue((Object)"86400").infoValue((Object)"86400").infoValue((Object)"86400").build()).build();
        return FluentIterable.from((Iterable)ImmutableList.of((Object)record));
    }
}

