/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.parse;

import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.ResourceRecord;
import org.jclouds.ultradns.ws.domain.ResourceRecordDetail;
import org.jclouds.ultradns.ws.xml.ResourceRecordListHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="GetResourceRecordsOfResourceRecordResponseTest")
public class GetResourceRecordsOfResourceRecordResponseTest
extends BaseHandlerTest {
    SimpleDateFormatDateService dateService = new SimpleDateFormatDateService();

    @Test
    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/records.xml");
        FluentIterable<ResourceRecordDetail> expected = this.expected();
        ResourceRecordListHandler handler = (ResourceRecordListHandler)this.injector.getInstance(ResourceRecordListHandler.class);
        FluentIterable result = (FluentIterable)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toList().toString(), (String)expected.toList().toString());
    }

    public FluentIterable<ResourceRecordDetail> expected() {
        ResourceRecordDetail.Builder builder = ResourceRecordDetail.builder().zoneId("0000000000000001").zoneName("jclouds.org.");
        ImmutableList records = ImmutableList.builder().add((Object)builder.guid("04023A2507B6468F").created(this.dateService.iso8601DateParse("2010-10-02T16:57:16.000Z")).modified(this.dateService.iso8601DateParse("2011-09-27T23:49:21.000Z")).record(ResourceRecord.rrBuilder().type(1).name("www.jclouds.org.").ttl(3600).rdata((Object)"1.2.3.4")).build()).add((Object)builder.guid("0B0338C2023F7969").created(this.dateService.iso8601DateParse("2009-10-12T12:02:23.000Z")).modified(this.dateService.iso8601DateParse("2009-10-12T12:02:23.000Z")).record(ResourceRecord.rrBuilder().type(2).name("jclouds.org.").ttl(86400).rdata((Object)"pdns2.ultradns.net.")).build()).add((Object)builder.guid("0B0338C2023F7968").created(this.dateService.iso8601DateParse("2009-10-12T12:02:23.000Z")).modified(this.dateService.iso8601DateParse("2009-10-12T12:02:23.000Z")).record(ResourceRecord.rrBuilder().type(2).name("jclouds.org.").ttl(86400).rdata((Object)"pdns1.ultradns.net.")).build()).add((Object)builder.guid("0B0338C2023F796B").created(this.dateService.iso8601DateParse("2009-10-12T12:02:23.000Z")).modified(this.dateService.iso8601DateParse("2009-10-12T12:02:23.000Z")).record(ResourceRecord.rrBuilder().type(2).name("jclouds.org.").ttl(86400).rdata((Object)"pdns4.ultradns.org.")).build()).add((Object)builder.guid("0B0338C2023F7983").created(this.dateService.iso8601DateParse("2009-10-12T12:02:23.000Z")).modified(this.dateService.iso8601DateParse("2011-09-27T23:49:22.000Z")).record(ResourceRecord.rrBuilder().type(6).name("jclouds.org.").ttl(3600).rdata(Splitter.on((char)' ').split((CharSequence)"pdns2.ultradns.net. admin.jclouds.org. 2011092701 10800 3600 604800 86400"))).build()).add((Object)builder.guid("0B0338C2023F796E").created(this.dateService.iso8601DateParse("2009-10-12T12:02:23.000Z")).modified(this.dateService.iso8601DateParse("2011-09-27T23:49:22.000Z")).record(ResourceRecord.rrBuilder().type(1).name("jclouds.org.").ttl(3600).rdata((Object)"1.2.3.4")).build()).add((Object)builder.guid("0B0338C2023F796C").created(this.dateService.iso8601DateParse("2009-10-12T12:02:23.000Z")).modified(this.dateService.iso8601DateParse("2009-10-12T12:02:23.000Z")).record(ResourceRecord.rrBuilder().type(2).name("jclouds.org.").ttl(86400).rdata((Object)"pdns5.ultradns.info.")).build()).add((Object)builder.guid("0B0338C2023F796D").created(this.dateService.iso8601DateParse("2009-10-12T12:02:23.000Z")).modified(this.dateService.iso8601DateParse("2009-10-12T12:02:23.000Z")).record(ResourceRecord.rrBuilder().type(2).name("jclouds.org.").ttl(86400).rdata((Object)"pdns6.ultradns.co.uk.")).build()).add((Object)builder.guid("0B0338C2023F796A").created(this.dateService.iso8601DateParse("2009-10-12T12:02:23.000Z")).modified(this.dateService.iso8601DateParse("2009-10-12T12:02:23.000Z")).record(ResourceRecord.rrBuilder().type(2).name("jclouds.org.").ttl(86400).rdata((Object)"pdns3.ultradns.org.")).build()).build();
        return FluentIterable.from((Iterable)records);
    }
}

