/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.predicates;

import org.jclouds.ultradns.ws.domain.TrafficControllerPool;
import org.jclouds.ultradns.ws.domain.TrafficControllerPoolRecord;
import org.jclouds.ultradns.ws.domain.TrafficControllerPoolRecordDetail;
import org.jclouds.ultradns.ws.predicates.TrafficControllerPoolPredicates;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="TrafficControllerPoolPredicatesTest")
public class TrafficControllerPoolPredicatesTest {
    TrafficControllerPool pool = TrafficControllerPool.builder().zoneId("0000000000000001").id("000000000000002").name("us-west-1c.discovery.jclouds.org.").dname("us-west-1c.discovery.jclouds.org.").statusCode(1).failOverEnabled(true).probingEnabled(true).build();
    TrafficControllerPoolRecordDetail record = TrafficControllerPoolRecordDetail.builder().id("0000000000000001").poolId("0000000000000001").record(TrafficControllerPoolRecord.createCNAME((String)"canary.jclouds.org.")).weight(2).priority(2).forceAnswer("Normal").probingEnabled(true).status(TrafficControllerPoolRecordDetail.Status.OK).serving(true).description("canary app").build();

    @Test
    public void testIdEqualToWhenEqual() {
        Assert.assertTrue((boolean)TrafficControllerPoolPredicates.idEqualTo((String)"000000000000002").apply((Object)this.pool));
    }

    @Test
    public void testIdEqualToWhenNotEqual() {
        Assert.assertFalse((boolean)TrafficControllerPoolPredicates.idEqualTo((String)"000000000000003").apply((Object)this.pool));
    }

    @Test
    public void testRecordIdEqualToWhenEqual() {
        Assert.assertTrue((boolean)TrafficControllerPoolPredicates.recordIdEqualTo((String)"0000000000000001").apply((Object)this.record));
    }

    @Test
    public void testRecordIdEqualToWhenNotEqual() {
        Assert.assertFalse((boolean)TrafficControllerPoolPredicates.recordIdEqualTo((String)"0000000000000002").apply((Object)this.record));
    }
}

