/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import jena.cmd.ArgDecl;
import jena.cmd.CmdArgModule;
import jena.cmd.CmdGeneral;
import jena.cmd.ModBase;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.resultset.ResultsFormat;
import org.apache.jena.sparql.util.QueryExecUtils;

public class ModResultsOut
extends ModBase {
    protected final ArgDecl resultsFmtDecl = new ArgDecl(true, new String[]{"results", "out", "rfmt"});
    private ResultsFormat resultsFormat = ResultsFormat.FMT_UNKNOWN;

    public void processArgs(CmdArgModule cmdline) throws IllegalArgumentException {
        if (cmdline.contains(this.resultsFmtDecl)) {
            String rFmt = cmdline.getValue(this.resultsFmtDecl);
            this.resultsFormat = ResultsFormat.lookup(rFmt);
            if (this.resultsFormat == null) {
                cmdline.cmdError("Unrecognized output format: " + rFmt);
            }
        }
    }

    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Results");
        cmdLine.add(this.resultsFmtDecl, "--results", "Results format (Result set: text, XML, JSON, CSV, TSV; Graph: RDF serialization)");
    }

    public void checkCommandLine(CmdArgModule cmdLine) {
    }

    public void printResultSet(ResultSet resultSet, Prologue prologue) {
        QueryExecUtils.outputResultSet(resultSet, prologue, this.resultsFormat);
    }

    public ResultsFormat getResultsFormat() {
        return this.resultsFormat;
    }
}

