/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import java.io.InputStream;
import java.io.Reader;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFErrorHandler;
import org.apache.jena.rdf.model.RDFReader;
import org.apache.jena.rdfxml.xmlinput.JenaReader;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.util.FileManager;
import org.apache.jena.util.FileUtils;

public class RDFReaderRIOT_ARP
implements RDFReader {
    static FileManager fileMgr = new FileManager();
    JenaReader reader = new JenaReader();

    public void read(Model model, Reader r, String base) {
        this.reader.read(model, r, base);
    }

    public void read(Model model, InputStream r, String base) {
        this.reader.read(model, r, base);
    }

    public void read(Model model, String url) {
        url = RDFReaderRIOT_ARP.fixupURL(url);
        this.reader.read(model, url);
    }

    private static String fixupURL(String url) {
        String scheme = FileUtils.getScheme((String)url);
        if (scheme != null && !scheme.equals("file") && !RDFReaderRIOT_ARP.isWindowsDrive(scheme)) {
            return url;
        }
        return IRILib.filenameToIRI((String)url);
    }

    private static boolean isWindowsDrive(String scheme) {
        return SysRIOT.isWindows && scheme.length() == 1;
    }

    public Object setProperty(String propName, Object propValue) {
        return this.reader.setProperty(propName, propValue);
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        return this.reader.setErrorHandler(errHandler);
    }

    static {
        fileMgr.addLocatorFile();
        fileMgr.addLocatorURL();
    }
}

