/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.RDFErrorHandler;
import org.apache.jena.rdfxml.xmlinput.ALiteral;
import org.apache.jena.rdfxml.xmlinput.ARP;
import org.apache.jena.rdfxml.xmlinput.ARPOptions;
import org.apache.jena.rdfxml.xmlinput.AResource;
import org.apache.jena.rdfxml.xmlinput.NamespaceHandler;
import org.apache.jena.rdfxml.xmlinput.ParseException;
import org.apache.jena.rdfxml.xmlinput.StatementHandler;
import org.apache.jena.rdfxml.xmlinput.impl.ARPSaxErrorHandler;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.checker.CheckerLiterals;
import org.apache.jena.riot.lang.LangRIOT;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LangRDFXML
implements LangRIOT {
    private ARP arp = new ARP();
    private InputStream input = null;
    private Reader reader = null;
    private String xmlBase;
    private String filename;
    private StreamRDF sink;
    private ParserProfile profile;
    public static boolean RiotUniformCompatibility = false;
    private static int[] additionalErrors = new int[]{115};

    @Override
    public ParserProfile getProfile() {
        return this.profile;
    }

    @Override
    public void setProfile(ParserProfile profile) {
        this.profile = profile;
    }

    public static LangRDFXML create(InputStream in, String xmlBase, String filename, ErrorHandler errorHandler, StreamRDF sink) {
        return new LangRDFXML(in, xmlBase, filename, errorHandler, sink);
    }

    public static LangRDFXML create(Reader reader, String xmlBase, String filename, ErrorHandler errorHandler, StreamRDF sink) {
        return new LangRDFXML(reader, xmlBase, filename, errorHandler, sink);
    }

    public static LangRDFXML create(String xmlBase, String filename, ErrorHandler errorHandler, StreamRDF sink) {
        return LangRDFXML.create(IO.openFile((String)filename), xmlBase, filename, errorHandler, sink);
    }

    private LangRDFXML(Reader reader, String xmlBase, String filename, ErrorHandler errorHandler, StreamRDF sink) {
        this.reader = reader;
        this.xmlBase = xmlBase;
        this.filename = filename;
        this.sink = sink;
        this.profile = RiotLib.profile(this.getLang(), xmlBase, errorHandler);
    }

    private LangRDFXML(InputStream in, String xmlBase, String filename, ErrorHandler errorHandler, StreamRDF sink) {
        this.input = in;
        this.xmlBase = xmlBase;
        this.filename = filename;
        this.sink = sink;
        this.profile = RiotLib.profile(this.getLang(), xmlBase, errorHandler);
    }

    @Override
    public Lang getLang() {
        return RDFLanguages.RDFXML;
    }

    @Override
    public void parse() {
        this.sink.start();
        HandlerSink rslt = new HandlerSink(this.sink, this.getProfile().getHandler());
        this.arp.getHandlers().setStatementHandler((StatementHandler)rslt);
        this.arp.getHandlers().setErrorHandler((org.xml.sax.ErrorHandler)((Object)rslt));
        this.arp.getHandlers().setNamespaceHandler((NamespaceHandler)rslt);
        if (RiotUniformCompatibility) {
            ARPOptions options = this.arp.getOptions();
            for (int code : additionalErrors) {
                options.setErrorMode(code, 3);
            }
            this.arp.setOptionsWith(options);
        }
        try {
            if (this.reader != null) {
                this.arp.load(this.reader, this.xmlBase);
            } else {
                this.arp.load(this.input, this.xmlBase);
            }
        }
        catch (IOException e2) {
            this.getProfile().getHandler().error(this.filename + ": " + ParseException.formatMessage((Exception)e2), -1L, -1L);
        }
        catch (SAXParseException e2) {
        }
        catch (SAXException sax) {
            this.getProfile().getHandler().error(this.filename + ": " + ParseException.formatMessage((Exception)sax), -1L, -1L);
        }
        this.sink.finish();
    }

    private static class ErrorHandlerBridge
    implements RDFErrorHandler {
        private ErrorHandler errorHandler;

        ErrorHandlerBridge(ErrorHandler hander) {
            this.errorHandler = hander;
        }

        public void warning(Exception e2) {
            Pair<Integer, Integer> p = ErrorHandlerBridge.getLineCol(e2);
            this.errorHandler.warning(e2.getMessage(), ((Integer)p.getLeft()).intValue(), ((Integer)p.getRight()).intValue());
        }

        public void error(Exception e2) {
            Pair<Integer, Integer> p = ErrorHandlerBridge.getLineCol(e2);
            this.errorHandler.error(e2.getMessage(), ((Integer)p.getLeft()).intValue(), ((Integer)p.getRight()).intValue());
        }

        public void fatalError(Exception e2) {
            Pair<Integer, Integer> p = ErrorHandlerBridge.getLineCol(e2);
            this.errorHandler.fatal(e2.getMessage(), ((Integer)p.getLeft()).intValue(), ((Integer)p.getRight()).intValue());
        }

        private static Pair<Integer, Integer> getLineCol(Exception e2) {
            if (e2 instanceof SAXParseException) {
                SAXParseException esax = (SAXParseException)e2;
                return Pair.create((Object)esax.getLineNumber(), (Object)esax.getColumnNumber());
            }
            return Pair.create((Object)-1, (Object)-1);
        }
    }

    private static class HandlerSink
    extends ARPSaxErrorHandler
    implements StatementHandler,
    NamespaceHandler {
        private StreamRDF output;
        private ErrorHandler errHandler;
        private CheckerLiterals checker;

        HandlerSink(StreamRDF output, ErrorHandler errHandler) {
            super((RDFErrorHandler)new ErrorHandlerBridge(errHandler));
            this.output = output;
            this.errHandler = errHandler;
            this.checker = new CheckerLiterals(errHandler);
        }

        public void statement(AResource subj, AResource pred, AResource obj) {
            this.output.triple(this.convert(subj, pred, obj));
        }

        public void statement(AResource subj, AResource pred, ALiteral lit) {
            this.output.triple(this.convert(subj, pred, lit));
        }

        private static Node convert(ALiteral lit) {
            String dtURI = lit.getDatatypeURI();
            if (dtURI == null) {
                return NodeFactory.createLiteral((String)lit.toString(), (String)lit.getLang());
            }
            if (lit.isWellFormedXML()) {
                return NodeFactory.createLiteral((String)lit.toString(), null, (boolean)true);
            }
            RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(dtURI);
            return NodeFactory.createLiteral((String)lit.toString(), (RDFDatatype)dt);
        }

        private static Node convert(AResource r) {
            if (!r.isAnonymous()) {
                return NodeFactory.createURI((String)r.getURI());
            }
            Node rr = (Node)r.getUserData();
            if (rr == null) {
                rr = NodeFactory.createBlankNode();
                r.setUserData((Object)rr);
            }
            return rr;
        }

        private Triple convert(AResource s, AResource p, AResource o) {
            return Triple.create((Node)HandlerSink.convert(s), (Node)HandlerSink.convert(p), (Node)HandlerSink.convert(o));
        }

        private Triple convert(AResource s, AResource p, ALiteral o) {
            Node object = HandlerSink.convert(o);
            this.checker.check(object, -1L, -1L);
            return Triple.create((Node)HandlerSink.convert(s), (Node)HandlerSink.convert(p), (Node)object);
        }

        public void startPrefixMapping(String prefix, String uri) {
            this.output.prefix(prefix, uri);
        }

        public void endPrefixMapping(String prefix) {
        }
    }
}

