/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpWalker;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.optimize.ExprTransformConstantFold;
import org.apache.jena.sparql.algebra.optimize.OpVisitorExprPrepare;
import org.apache.jena.sparql.algebra.optimize.Rewrite;
import org.apache.jena.sparql.algebra.optimize.TransformDistinctToReduced;
import org.apache.jena.sparql.algebra.optimize.TransformEliminateAssignments;
import org.apache.jena.sparql.algebra.optimize.TransformExpandOneOf;
import org.apache.jena.sparql.algebra.optimize.TransformExtendCombine;
import org.apache.jena.sparql.algebra.optimize.TransformFilterConjunction;
import org.apache.jena.sparql.algebra.optimize.TransformFilterDisjunction;
import org.apache.jena.sparql.algebra.optimize.TransformFilterEquality;
import org.apache.jena.sparql.algebra.optimize.TransformFilterImplicitJoin;
import org.apache.jena.sparql.algebra.optimize.TransformFilterInequality;
import org.apache.jena.sparql.algebra.optimize.TransformFilterPlacement;
import org.apache.jena.sparql.algebra.optimize.TransformFilterPlacementConservative;
import org.apache.jena.sparql.algebra.optimize.TransformImplicitLeftJoin;
import org.apache.jena.sparql.algebra.optimize.TransformJoinStrategy;
import org.apache.jena.sparql.algebra.optimize.TransformMergeBGPs;
import org.apache.jena.sparql.algebra.optimize.TransformOrderByDistinctApplication;
import org.apache.jena.sparql.algebra.optimize.TransformPathFlattern;
import org.apache.jena.sparql.algebra.optimize.TransformPromoteTableEmpty;
import org.apache.jena.sparql.algebra.optimize.TransformPropertyFunction;
import org.apache.jena.sparql.algebra.optimize.TransformScopeRename;
import org.apache.jena.sparql.algebra.optimize.TransformTopN;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Optimize
implements Rewrite {
    private static Logger log = LoggerFactory.getLogger(Optimize.class);
    public static RewriterFactory noOptimizationFactory = new RewriterFactory(){

        @Override
        public Rewrite create(Context context) {
            return new Rewrite(){

                @Override
                public Op rewrite(Op op) {
                    return op;
                }
            };
        }
    };
    public static RewriterFactory stdOptimizationFactory;
    private static RewriterFactory factory;
    private final Context context;
    public static final Symbol filterPlacementOldName;

    public static Op optimize(Op op, ExecutionContext execCxt) {
        return Optimize.optimize(op, execCxt.getContext());
    }

    public static Op optimize(Op op, Context context) {
        Rewrite opt = Optimize.decideOptimizer(context);
        return opt.rewrite(op);
    }

    public static void noOptimizer() {
        Optimize.setFactory(noOptimizationFactory);
    }

    private static Rewrite decideOptimizer(Context context) {
        RewriterFactory f = (RewriterFactory)context.get(ARQConstants.sysOptimizerFactory);
        if (f == null) {
            f = factory;
        }
        if (f == null) {
            f = stdOptimizationFactory;
        }
        return f.create(context);
    }

    public static void setFactory(RewriterFactory aFactory) {
        factory = aFactory;
    }

    public static RewriterFactory getFactory() {
        return factory;
    }

    private Optimize(ExecutionContext execCxt) {
        this(execCxt.getContext());
    }

    private Optimize(Context context) {
        this.context = context;
    }

    @Override
    public Op rewrite(Op op) {
        if (this.context.get(ARQConstants.sysOptimizer) == null) {
            this.context.set(ARQConstants.sysOptimizer, this);
        }
        if (this.context.isDefined(filterPlacementOldName) && this.context.isUndef(ARQ.optFilterPlacement)) {
            this.context.set(ARQ.optFilterPlacement, this.context.get(filterPlacementOldName));
        }
        op = TransformScopeRename.transform(op);
        OpWalker.walk(op, new OpVisitorExprPrepare(this.context));
        if (this.context.isTrueOrUndef(ARQ.optPathFlatten)) {
            op = Optimize.apply("Path flattening", new TransformPathFlattern(), op);
            if (this.context.isTrueOrUndef(ARQ.optMergeBGPs)) {
                op = Optimize.apply("Merge BGPs", new TransformMergeBGPs(), op);
            }
        }
        if (this.context.isTrueOrUndef(ARQ.optExprConstantFolding)) {
            op = Transformer.transform(new TransformCopy(), new ExprTransformConstantFold(), op);
        }
        if (this.context.isTrueOrUndef(ARQ.propertyFunctions)) {
            op = Optimize.apply("Property Functions", new TransformPropertyFunction(this.context), op);
        }
        if (this.context.isTrueOrUndef(ARQ.optFilterConjunction)) {
            op = Optimize.apply("filter conjunctions to ExprLists", new TransformFilterConjunction(), op);
        }
        if (this.context.isTrueOrUndef(ARQ.optFilterExpandOneOf)) {
            op = Optimize.apply("Break up IN and NOT IN", new TransformExpandOneOf(), op);
        }
        if (this.context.isTrue(ARQ.optInlineAssignments)) {
            op = TransformEliminateAssignments.eliminate(op, this.context.isTrue(ARQ.optInlineAssignmentsAggressive));
        }
        if (this.context.isTrueOrUndef(ARQ.optFilterImplicitJoin)) {
            op = Optimize.apply("Filter Implicit Join", new TransformFilterImplicitJoin(), op);
        }
        if (this.context.isTrueOrUndef(ARQ.optImplicitLeftJoin)) {
            op = Optimize.apply("Implicit Left Join", new TransformImplicitLeftJoin(), op);
        }
        if (this.context.isTrueOrUndef(ARQ.optFilterDisjunction)) {
            op = Optimize.apply("Filter Disjunction", new TransformFilterDisjunction(), op);
        }
        if (this.context.isTrueOrUndef(ARQ.optTopNSorting)) {
            op = Optimize.apply("TopN Sorting", new TransformTopN(), op);
        }
        if (this.context.isTrueOrUndef(ARQ.optOrderByDistinctApplication)) {
            op = Optimize.apply("Apply DISTINCT prior to ORDER BY where possible", new TransformOrderByDistinctApplication(), op);
        }
        if (this.context.isTrueOrUndef(ARQ.optDistinctToReduced)) {
            op = Optimize.apply("Distinct replaced with reduced", new TransformDistinctToReduced(), op);
        }
        if (this.context.isTrueOrUndef(ARQ.optIndexJoinStrategy)) {
            op = Optimize.apply("Index Join strategy", new TransformJoinStrategy(), op);
        }
        if (this.context.isTrueOrUndef(ARQ.optFilterPlacement)) {
            if (this.context.isTrue(ARQ.optFilterPlacementConservative)) {
                op = Optimize.apply("Filter Placement (conservative)", new TransformFilterPlacementConservative(), op);
            } else {
                boolean b = this.context.isTrueOrUndef(ARQ.optFilterPlacementBGP);
                op = Optimize.apply("Filter Placement", new TransformFilterPlacement(b), op);
            }
        }
        if (this.context.isTrueOrUndef(ARQ.optFilterEquality)) {
            op = Optimize.apply("Filter Equality", new TransformFilterEquality(), op);
        }
        if (this.context.isTrue(ARQ.optFilterInequality)) {
            op = Optimize.apply("Filter Inequality", new TransformFilterInequality(), op);
        }
        if (this.context.isTrueOrUndef(ARQ.optPromoteTableEmpty)) {
            op = Optimize.apply("Table Empty Promotion", new TransformPromoteTableEmpty(), op);
        }
        if (this.context.isTrueOrUndef(ARQ.optMergeBGPs)) {
            op = Optimize.apply("Merge BGPs", new TransformMergeBGPs(), op);
        }
        if (this.context.isTrueOrUndef(ARQ.optMergeExtends)) {
            op = Optimize.apply("Combine BIND/LET", new TransformExtendCombine(), op);
        }
        return op;
    }

    public static Op apply(Transform transform, Op op) {
        Op op2 = Transformer.transformSkipService(transform, op);
        if (op2 != op) {
            return op2;
        }
        return op;
    }

    public static Op apply(String label, Transform transform, Op op) {
        Op op2 = Transformer.transformSkipService(transform, op);
        boolean debug2 = false;
        if (op2 != op) {
            return op2;
        }
        return op;
    }

    static {
        factory = stdOptimizationFactory = new RewriterFactory(){

            @Override
            public Rewrite create(Context context) {
                return new Optimize(context);
            }
        };
        filterPlacementOldName = ARQConstants.allocSymbol("filterPlacement");
    }

    public static interface RewriterFactory {
        public Rewrite create(Context var1);
    }
}

