/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.JoinType;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.table.TableUnit;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterFilterExpr;
import org.apache.jena.sparql.engine.iterator.QueryIterNullIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;

public class TableJoin {
    public static QueryIterator join(QueryIterator left, Table right, ExprList condition, ExecutionContext execCxt) {
        return TableJoin.joinWorker(left, right, JoinType.PLAIN, condition, execCxt);
    }

    public static QueryIterator leftJoin(QueryIterator left, Table right, ExprList condition, ExecutionContext execCxt) {
        return TableJoin.joinWorker(left, right, JoinType.LEFT, condition, execCxt);
    }

    public static QueryIterator joinWorker(QueryIterator left, Table right, JoinType joinType, ExprList conditions, ExecutionContext execCxt) {
        if (right.isEmpty()) {
            if (joinType == JoinType.PLAIN) {
                left.close();
                return QueryIterNullIterator.create(execCxt);
            }
            return left;
        }
        if (TableUnit.isTableUnit(right)) {
            if (joinType == JoinType.PLAIN) {
                return TableJoin.applyConditions(left, conditions, execCxt);
            }
            return left;
        }
        return TableJoin.joinWorkerN(left, right, joinType, conditions, execCxt);
    }

    private static QueryIterator joinWorkerN(QueryIterator left, Table right, JoinType joinType, ExprList conditions, ExecutionContext execCxt) {
        ArrayList<Binding> out = new ArrayList<Binding>();
        while (left.hasNext()) {
            Binding bindingLeft = (Binding)left.next();
            int count = 0;
            Iterator<Binding> iter = right.rows();
            while (iter.hasNext()) {
                Binding bindingRight = iter.next();
                Binding r = Algebra.merge(bindingLeft, bindingRight);
                if (r == null || conditions != null && !conditions.isSatisfied(r, execCxt)) continue;
                ++count;
                out.add(r);
            }
            if (count != 0 || joinType != JoinType.LEFT) continue;
            out.add(bindingLeft);
        }
        return new QueryIterPlainWrapper(out.iterator(), execCxt);
    }

    private static QueryIterator applyConditions(QueryIterator qIter, ExprList conditions, ExecutionContext execCxt) {
        if (conditions == null) {
            return qIter;
        }
        for (Expr expr : conditions) {
            qIter = new QueryIterFilterExpr(qIter, expr, execCxt);
        }
        return qIter;
    }
}

