/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.engine.iterator.QueryIteratorCheck;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.syntax.Element;

public abstract class ExprFunctionOp
extends ExprFunction {
    private final Op op;
    private Op opRun = null;
    private final Element element;

    protected ExprFunctionOp(String fName, Element el, Op op) {
        super(fName);
        this.op = op;
        this.element = el;
    }

    @Override
    public Expr getArg(int i) {
        return null;
    }

    @Override
    public boolean isGraphPattern() {
        return true;
    }

    @Override
    public Op getGraphPattern() {
        return this.op;
    }

    public Element getElement() {
        return this.element;
    }

    @Override
    public int numArgs() {
        return 0;
    }

    @Override
    public final NodeValue eval(Binding binding, FunctionEnv env) {
        ExecutionContext execCxt = new ExecutionContext(env.getContext(), env.getActiveGraph(), env.getDataset(), QC.getFactory(env.getContext()));
        QueryIterSingleton qIter1 = QueryIterSingleton.create(binding, execCxt);
        QueryIterator qIter = QC.execute(this.op, qIter1, execCxt);
        qIter = QueryIteratorCheck.check(qIter, execCxt);
        NodeValue v = this.eval(binding, qIter, env);
        qIter.close();
        return v;
    }

    protected abstract NodeValue eval(Binding var1, QueryIterator var2, FunctionEnv var3);

    public abstract ExprFunctionOp copy(ExprList var1, Op var2);

    public abstract ExprFunctionOp copy(ExprList var1, Element var2);

    @Override
    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }

    public Expr apply(ExprTransform transform, ExprList args, Op x) {
        return transform.transform(this, args, x);
    }
}

