/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.aggregate;

import org.apache.jena.graph.Node;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.expr.aggregate.AccumulatorExpr;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.expr.aggregate.AggregatorBase;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.graph.NodeConst;

public class AggCountVar
extends AggregatorBase {
    public AggCountVar(Expr expr) {
        super("COUNT", false, expr);
    }

    @Override
    public Aggregator copy(ExprList expr) {
        return new AggCountVar(expr.get(0));
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccCountVar(this.getExpr());
    }

    @Override
    public int hashCode() {
        return 0x174 ^ this.exprList.hashCode();
    }

    @Override
    public boolean equals(Aggregator other, boolean bySyntax) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggCountVar)) {
            return false;
        }
        AggCountVar agg = (AggCountVar)other;
        return agg.getExpr().equals(this.getExpr(), bySyntax);
    }

    @Override
    public Node getValueEmpty() {
        return NodeConst.nodeZero;
    }

    private static class AccCountVar
    extends AccumulatorExpr {
        private long count = 0L;

        public AccCountVar(Expr expr) {
            super(expr);
        }

        @Override
        public void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            ++this.count;
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        @Override
        public NodeValue getValue() {
            return this.getAccValue();
        }

        @Override
        public NodeValue getAccValue() {
            return NodeValue.makeInteger(this.count);
        }
    }
}

