/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.aggregate;

import org.apache.jena.graph.Node;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.expr.aggregate.AccumulatorExpr;
import org.apache.jena.sparql.expr.aggregate.AggregatorBase;
import org.apache.jena.sparql.function.FunctionEnv;

abstract class AggMaxBase
extends AggregatorBase {
    protected AggMaxBase(Expr expr, boolean isDistinct) {
        super("MAX", isDistinct, expr);
    }

    @Override
    public final Accumulator createAccumulator() {
        return new AccMax(this.getExpr());
    }

    @Override
    public final Node getValueEmpty() {
        return null;
    }

    private static class AccMax
    extends AccumulatorExpr {
        private NodeValue maxSoFar = null;
        static final boolean DEBUG = false;

        public AccMax(Expr expr) {
            super(expr);
        }

        @Override
        public void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            if (this.maxSoFar == null) {
                this.maxSoFar = nv;
                return;
            }
            int x = NodeValue.compareAlways(this.maxSoFar, nv);
            if (x < 0) {
                this.maxSoFar = nv;
            }
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        @Override
        public NodeValue getAccValue() {
            return this.maxSoFar;
        }
    }
}

