/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function;

import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.sparql.function.CastXSD;
import org.apache.jena.sparql.function.CastXSD_Boolean;
import org.apache.jena.sparql.function.CastXSD_DateTime;
import org.apache.jena.sparql.function.CastXSD_Numeric;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.function.library.FN_Abs;
import org.apache.jena.sparql.function.library.FN_BEV;
import org.apache.jena.sparql.function.library.FN_Ceiling;
import org.apache.jena.sparql.function.library.FN_DayFromDateTime;
import org.apache.jena.sparql.function.library.FN_DaysFromDuration;
import org.apache.jena.sparql.function.library.FN_Floor;
import org.apache.jena.sparql.function.library.FN_HoursFromDateTime;
import org.apache.jena.sparql.function.library.FN_HoursFromDuration;
import org.apache.jena.sparql.function.library.FN_Matches;
import org.apache.jena.sparql.function.library.FN_MinutesFromDateTime;
import org.apache.jena.sparql.function.library.FN_MinutesFromDuration;
import org.apache.jena.sparql.function.library.FN_MonthFromDateTime;
import org.apache.jena.sparql.function.library.FN_MonthsFromDuration;
import org.apache.jena.sparql.function.library.FN_Not;
import org.apache.jena.sparql.function.library.FN_Round;
import org.apache.jena.sparql.function.library.FN_SecondsFromDateTime;
import org.apache.jena.sparql.function.library.FN_SecondsFromDuration;
import org.apache.jena.sparql.function.library.FN_StrAfter;
import org.apache.jena.sparql.function.library.FN_StrBefore;
import org.apache.jena.sparql.function.library.FN_StrConcat;
import org.apache.jena.sparql.function.library.FN_StrContains;
import org.apache.jena.sparql.function.library.FN_StrEncodeForURI;
import org.apache.jena.sparql.function.library.FN_StrEndsWith;
import org.apache.jena.sparql.function.library.FN_StrLength;
import org.apache.jena.sparql.function.library.FN_StrLowerCase;
import org.apache.jena.sparql.function.library.FN_StrStartsWith;
import org.apache.jena.sparql.function.library.FN_StrSubstring;
import org.apache.jena.sparql.function.library.FN_StrUpperCase;
import org.apache.jena.sparql.function.library.FN_TimezoneFromDateTime;
import org.apache.jena.sparql.function.library.FN_YearFromDateTime;
import org.apache.jena.sparql.function.library.FN_YearsFromDuration;

public class StandardFunctions {
    public static void loadStdDefs(FunctionRegistry registry) {
        String xfn = "http://www.w3.org/2005/xpath-functions#";
        String sparqlfn = "http://www.w3.org/ns/sparql#";
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDdecimal);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDinteger);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDlong);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDint);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDshort);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDbyte);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDnonPositiveInteger);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDnegativeInteger);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDnonNegativeInteger);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDpositiveInteger);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDunsignedLong);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDunsignedInt);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDunsignedShort);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDdouble);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDfloat);
        StandardFunctions.addCastBoolean(registry, XSDDatatype.XSDboolean);
        StandardFunctions.addCast(registry, XSDDatatype.XSDduration);
        StandardFunctions.addCast(registry, XSDDatatype.XSDstring);
        StandardFunctions.addCast(registry, XSDDatatype.XSDanyURI);
        StandardFunctions.addCastDT(registry, XSDDatatype.XSDdateTime);
        StandardFunctions.addCastDT(registry, XSDDatatype.XSDdate);
        StandardFunctions.addCastDT(registry, XSDDatatype.XSDtime);
        StandardFunctions.addCastDT(registry, XSDDatatype.XSDgYear);
        StandardFunctions.addCastDT(registry, XSDDatatype.XSDgYearMonth);
        StandardFunctions.addCastDT(registry, XSDDatatype.XSDgMonth);
        StandardFunctions.addCastDT(registry, XSDDatatype.XSDgMonthDay);
        StandardFunctions.addCastDT(registry, XSDDatatype.XSDgDay);
        StandardFunctions.add(registry, xfn + "boolean", FN_BEV.class);
        StandardFunctions.add(registry, xfn + "not", FN_Not.class);
        StandardFunctions.add(registry, xfn + "matches", FN_Matches.class);
        StandardFunctions.add(registry, xfn + "string-length", FN_StrLength.class);
        StandardFunctions.add(registry, xfn + "concat", FN_StrConcat.class);
        StandardFunctions.add(registry, xfn + "substring", FN_StrSubstring.class);
        StandardFunctions.add(registry, xfn + "starts-with", FN_StrStartsWith.class);
        StandardFunctions.add(registry, xfn + "lower-case", FN_StrLowerCase.class);
        StandardFunctions.add(registry, xfn + "upper-case", FN_StrUpperCase.class);
        StandardFunctions.add(registry, xfn + "contains", FN_StrContains.class);
        StandardFunctions.add(registry, xfn + "ends-with", FN_StrEndsWith.class);
        StandardFunctions.add(registry, xfn + "substring-before", FN_StrBefore.class);
        StandardFunctions.add(registry, xfn + "substring-after", FN_StrAfter.class);
        StandardFunctions.add(registry, xfn + "abs", FN_Abs.class);
        StandardFunctions.add(registry, xfn + "ceiling", FN_Ceiling.class);
        StandardFunctions.add(registry, xfn + "floor", FN_Floor.class);
        StandardFunctions.add(registry, xfn + "round", FN_Round.class);
        StandardFunctions.add(registry, xfn + "encode-for-uri", FN_StrEncodeForURI.class);
        StandardFunctions.add(registry, xfn + "year-from-dateTime", FN_YearFromDateTime.class);
        StandardFunctions.add(registry, xfn + "month-from-dateTime", FN_MonthFromDateTime.class);
        StandardFunctions.add(registry, xfn + "day-from-dateTime", FN_DayFromDateTime.class);
        StandardFunctions.add(registry, xfn + "hours-from-dateTime", FN_HoursFromDateTime.class);
        StandardFunctions.add(registry, xfn + "minutes-from-dateTime", FN_MinutesFromDateTime.class);
        StandardFunctions.add(registry, xfn + "seconds-from-dateTime", FN_SecondsFromDateTime.class);
        StandardFunctions.add(registry, xfn + "timezone-from-dateTime", FN_TimezoneFromDateTime.class);
        StandardFunctions.add(registry, xfn + "years-from-duration", FN_YearsFromDuration.class);
        StandardFunctions.add(registry, xfn + "months-from-duration", FN_MonthsFromDuration.class);
        StandardFunctions.add(registry, xfn + "days-from-duration", FN_DaysFromDuration.class);
        StandardFunctions.add(registry, xfn + "hours-from-duration", FN_HoursFromDuration.class);
        StandardFunctions.add(registry, xfn + "minutes-from-duration", FN_MinutesFromDuration.class);
        StandardFunctions.add(registry, xfn + "seconds-from-duration", FN_SecondsFromDuration.class);
    }

    private static void addCast(FunctionRegistry registry, XSDDatatype dt) {
        registry.put(dt.getURI(), new CastXSD(dt));
    }

    private static void addCastNumeric(FunctionRegistry registry, XSDDatatype dt) {
        registry.put(dt.getURI(), new CastXSD_Numeric(dt));
    }

    private static void addCastBoolean(FunctionRegistry registry, XSDDatatype dt) {
        registry.put(dt.getURI(), new CastXSD_Boolean(dt));
    }

    private static void addCastDT(FunctionRegistry registry, XSDDatatype dt) {
        registry.put(dt.getURI(), new CastXSD_DateTime(dt));
    }

    private static void add(FunctionRegistry registry, String uri, Class<?> funcClass) {
        registry.put(uri, funcClass);
    }
}

