/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax.syntaxtransform;

import java.util.List;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformCopyBase;

public class ElementTransformCleanGroupsOfOne
extends ElementTransformCopyBase {
    @Override
    public Element transform(ElementGroup eltGroup, List<Element> elts) {
        if (elts.size() != 1) {
            return super.transform(eltGroup, elts);
        }
        Element elt = elts.get(0);
        if (elt instanceof ElementTriplesBlock || elt instanceof ElementPathBlock || elt instanceof ElementFilter) {
            return super.transform(eltGroup, elts);
        }
        return elt;
    }

    @Override
    public Element transform(ElementOptional eltOptional, Element transformedElt) {
        Element x;
        if (!(transformedElt instanceof ElementGroup)) {
            ElementGroup protectedElt = new ElementGroup();
            protectedElt.addElement(transformedElt);
            transformedElt = protectedElt;
        }
        if (!((x = eltOptional.getOptionalElement()) instanceof ElementGroup)) {
            return super.transform(eltOptional, transformedElt);
        }
        ElementGroup eGroup = (ElementGroup)x;
        if (eGroup.size() != 1) {
            return super.transform(eltOptional, transformedElt);
        }
        Element inner = eGroup.get(0);
        if (!(inner instanceof ElementGroup)) {
            return super.transform(eltOptional, transformedElt);
        }
        ElementGroup innerGroup = (ElementGroup)inner;
        boolean mustProtect = this.containsFilter(innerGroup = this.unwrap(innerGroup));
        if (mustProtect) {
            ElementGroup protectedElt = new ElementGroup();
            protectedElt.addElement(transformedElt);
            return new ElementOptional(protectedElt);
        }
        return super.transform(eltOptional, transformedElt);
    }

    private boolean containsFilter(ElementGroup eltGroup) {
        return eltGroup.getElements().stream().anyMatch(el2 -> el2 instanceof ElementFilter);
    }

    private ElementGroup unwrap(ElementGroup eltGroup) {
        if (eltGroup.size() != 1) {
            return eltGroup;
        }
        Element el = eltGroup.get(0);
        if (!(el instanceof ElementGroup)) {
            return eltGroup;
        }
        ElementGroup eltGroup2 = (ElementGroup)el;
        return this.unwrap(eltGroup2);
    }
}

