/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.web;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.web.ContentType;

public class TypedInputStream
extends FilterInputStream {
    private ContentType mediaType;
    private String baseURI;
    private boolean isClosed = false;

    public static TypedInputStream wrap(InputStream in) {
        return new TypedInputStream(in);
    }

    private TypedInputStream(InputStream in) {
        this(in, (ContentType)null, null);
    }

    public TypedInputStream(InputStream in, String contentType) {
        this(in, ContentType.create(contentType), null);
    }

    public TypedInputStream(InputStream in, String mediaType, String charset) {
        this(in, mediaType, charset, null);
    }

    public TypedInputStream(InputStream in, String mediaType, String charset, String baseURI) {
        this(in, ContentType.create(mediaType, charset), baseURI);
    }

    public TypedInputStream(InputStream in, ContentType ct) {
        this(in, ct, null);
    }

    public TypedInputStream(InputStream in, ContentType ct, String baseURI) {
        super(in);
        this.mediaType = ct;
        this.baseURI = baseURI;
    }

    public String getContentType() {
        return this.mediaType == null ? null : this.mediaType.getContentType();
    }

    public String getCharset() {
        return this.mediaType == null ? null : this.mediaType.getCharset();
    }

    public ContentType getMediaType() {
        return this.mediaType;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            super.close();
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
        }
    }
}

