/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.util.Iterator;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.resultset.ResultSetException;

public class SPARQLResult {
    private boolean hasBeenSet = false;
    private ResultSet resultSet = null;
    private Boolean booleanResult = null;
    private Model model = null;
    private Dataset dataset = null;
    private Iterator<JsonObject> jsonItems = null;

    protected SPARQLResult() {
    }

    public SPARQLResult(Model model) {
        this.set(model);
    }

    public SPARQLResult(ResultSet resultSet) {
        this.set(resultSet);
    }

    public SPARQLResult(boolean booleanResult) {
        this.set(booleanResult);
    }

    public SPARQLResult(Dataset dataset) {
        this.set(dataset);
    }

    public SPARQLResult(Iterator<JsonObject> jsonItems) {
        this.set(jsonItems);
    }

    public boolean isResultSet() {
        if (!this.hasBeenSet) {
            throw new ResultSetException("Not set");
        }
        return this.resultSet != null;
    }

    public boolean isModel() {
        return this.isGraph();
    }

    public boolean isGraph() {
        if (!this.hasBeenSet) {
            throw new ResultSetException("Not set");
        }
        return this.model != null;
    }

    public boolean isDataset() {
        if (!this.hasBeenSet) {
            throw new ResultSetException("Not set");
        }
        return this.dataset != null;
    }

    public boolean isBoolean() {
        if (!this.hasBeenSet) {
            throw new ResultSetException("Not set");
        }
        return this.booleanResult != null;
    }

    public boolean isJson() {
        if (!this.hasBeenSet) {
            throw new ResultSetException("Not set");
        }
        return this.jsonItems != null;
    }

    public ResultSet getResultSet() {
        if (!this.hasBeenSet) {
            throw new ResultSetException("Not set");
        }
        if (!this.isResultSet()) {
            throw new ResultSetException("Not a ResultSet result");
        }
        return this.resultSet;
    }

    public Boolean getBooleanResult() {
        if (!this.hasBeenSet) {
            throw new ResultSetException("Not set");
        }
        if (!this.isBoolean()) {
            throw new ResultSetException("Not a boolean result");
        }
        return this.booleanResult;
    }

    public Model getModel() {
        if (!this.hasBeenSet) {
            throw new ResultSetException("Not set");
        }
        if (!this.isModel()) {
            throw new ResultSetException("Not a graph result");
        }
        return this.model;
    }

    public Dataset getDataset() {
        if (!this.hasBeenSet) {
            throw new ResultSetException("Not set");
        }
        if (!this.isDataset()) {
            throw new ResultSetException("Not a dataset result");
        }
        return this.dataset;
    }

    public Iterator<JsonObject> getJsonItems() {
        if (!this.hasBeenSet) {
            throw new ResultSetException("Not set");
        }
        if (!this.isJson()) {
            throw new ResultSetException("Not a JSON result");
        }
        return this.jsonItems;
    }

    public boolean isHasBeenSet() {
        return this.hasBeenSet;
    }

    protected void set(ResultSet rs) {
        this.resultSet = rs;
        this.hasBeenSet = true;
    }

    protected void set(Model m) {
        this.model = m;
        this.hasBeenSet = true;
    }

    protected void set(Dataset d) {
        this.dataset = d;
        this.hasBeenSet = true;
    }

    protected void set(boolean r) {
        this.set(new Boolean(r));
    }

    protected void set(Boolean r) {
        this.booleanResult = r;
        this.hasBeenSet = true;
    }

    protected void set(Iterator<JsonObject> jsonItems) {
        this.jsonItems = jsonItems;
        this.hasBeenSet = true;
    }
}

