/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax.syntaxtransform;

import java.util.List;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryVisitor;
import org.apache.jena.query.SortCondition;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformSubst;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformer;
import org.apache.jena.sparql.syntax.syntaxtransform.ExprTransformApplyElementTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.ExprTransformNodeElement;
import org.apache.jena.sparql.syntax.syntaxtransform.NodeTransformSubst;
import org.apache.jena.sparql.syntax.syntaxtransform.TransformElementLib;

public class QueryTransformOps {
    public static Query transform(Query query, Map<Var, ? extends Node> substitutions) {
        ElementTransformSubst eltrans = new ElementTransformSubst(substitutions);
        NodeTransformSubst nodeTransform = new NodeTransformSubst(substitutions);
        ExprTransformNodeElement exprTrans = new ExprTransformNodeElement(nodeTransform, eltrans);
        return QueryTransformOps.transform(query, eltrans, exprTrans);
    }

    public static Query transformQuery(Query query, Map<String, ? extends RDFNode> substitutions) {
        Map<Var, Node> map = TransformElementLib.convert(substitutions);
        return QueryTransformOps.transform(query, map);
    }

    public static Query transform(Query query, ElementTransform transform, ExprTransform exprTransform) {
        Element el;
        Element el2;
        Query q2 = QueryTransformOps.shallowCopy(query);
        QueryTransformOps.transformVarExprList(q2.getProject(), exprTransform);
        QueryTransformOps.transformVarExprList(q2.getGroupBy(), exprTransform);
        QueryTransformOps.transformExprList(q2.getHavingExprs(), exprTransform);
        if (q2.getOrderBy() != null) {
            QueryTransformOps.transformSortConditions(q2.getOrderBy(), exprTransform);
        }
        if (!((el2 = ElementTransformer.transform(el = q2.getQueryPattern(), transform, exprTransform)) instanceof ElementGroup)) {
            ElementGroup eg = new ElementGroup();
            eg.addElement(el2);
            el2 = eg;
        }
        q2.setQueryPattern(el2);
        return q2;
    }

    public static Query transform(Query query, ElementTransform transform) {
        ExprTransformApplyElementTransform noop = new ExprTransformApplyElementTransform(transform);
        return QueryTransformOps.transform(query, transform, noop);
    }

    private static void transformExprList(List<Expr> exprList, ExprTransform exprTransform) {
        for (int i = 0; i < exprList.size(); ++i) {
            Expr e1 = exprList.get(0);
            Expr e2 = ExprTransformer.transform(exprTransform, e1);
            if (e2 == null || e2 == e1) continue;
            exprList.set(i, e2);
        }
    }

    private static void transformSortConditions(List<SortCondition> conditions, ExprTransform exprTransform) {
        for (int i = 0; i < conditions.size(); ++i) {
            SortCondition s1 = conditions.get(i);
            Expr e2 = ExprTransformer.transform(exprTransform, s1.expression);
            if (e2 == null || s1.expression.equals(e2)) continue;
            conditions.set(i, new SortCondition(e2, s1.direction));
        }
    }

    private static void transformVarExprList(VarExprList varExprList, ExprTransform exprTransform) {
        Map<Var, Expr> map = varExprList.getExprs();
        for (Var v : varExprList.getVars()) {
            Expr e2;
            Expr e3 = varExprList.getExpr(v);
            ExprVar ev = new ExprVar(v);
            Expr ev2 = exprTransform.transform(ev);
            if (ev != ev2) {
                if (e3 != null) {
                    throw new ARQException("Can't substitute " + (Object)((Object)v) + " because it's used as an AS variable");
                }
                if (ev2.isConstant() || ev2.isVariable()) {
                    map.put(v, ev2);
                    continue;
                }
                throw new ARQException("Can't substitute " + (Object)((Object)v) + " because it's not a simple value: " + ev2);
            }
            if (e3 == null || e3 == (e2 = ExprTransformer.transform(exprTransform, e3))) continue;
            map.put(v, e2);
        }
    }

    public static Query shallowCopy(Query query) {
        QueryShallowCopy copy = new QueryShallowCopy();
        query.visit(copy);
        Query q2 = copy.newQuery;
        return q2;
    }

    static class QueryShallowCopy
    implements QueryVisitor {
        final Query newQuery = new Query();

        QueryShallowCopy() {
        }

        @Override
        public void startVisit(Query query) {
            this.newQuery.setSyntax(query.getSyntax());
            if (query.explicitlySetBaseURI()) {
                this.newQuery.setBaseURI(query.getPrologue().getResolver());
            }
            this.newQuery.setQueryResultStar(query.isQueryResultStar());
            if (query.hasDatasetDescription()) {
                DatasetDescription desc = query.getDatasetDescription();
                for (String x : desc.getDefaultGraphURIs()) {
                    this.newQuery.addGraphURI(x);
                }
                for (String x : desc.getDefaultGraphURIs()) {
                    this.newQuery.addNamedGraphURI(x);
                }
            }
            this.newQuery.getAggregators().addAll(query.getAggregators());
        }

        @Override
        public void visitPrologue(Prologue prologue) {
            PrefixMapping pmap = new PrefixMappingImpl().setNsPrefixes(prologue.getPrefixMapping());
            this.newQuery.setPrefixMapping(pmap);
        }

        @Override
        public void visitResultForm(Query q) {
        }

        @Override
        public void visitSelectResultForm(Query query) {
            this.newQuery.setQuerySelectType();
            this.newQuery.setDistinct(query.isDistinct());
            VarExprList x = query.getProject();
            for (Var v : x.getVars()) {
                Expr expr = x.getExpr(v);
                if (expr == null) {
                    this.newQuery.addResultVar((Node)v);
                    continue;
                }
                this.newQuery.addResultVar((Node)v, expr);
            }
        }

        @Override
        public void visitConstructResultForm(Query query) {
            this.newQuery.setQueryConstructType();
            this.newQuery.setConstructTemplate(query.getConstructTemplate());
        }

        @Override
        public void visitDescribeResultForm(Query query) {
            this.newQuery.setQueryDescribeType();
            for (Node x : query.getResultURIs()) {
                this.newQuery.addDescribeNode(x);
            }
        }

        @Override
        public void visitAskResultForm(Query query) {
            this.newQuery.setQueryAskType();
        }

        @Override
        public void visitJsonResultForm(Query query) {
            this.newQuery.setQueryJsonType();
        }

        @Override
        public void visitDatasetDecl(Query query) {
        }

        @Override
        public void visitQueryPattern(Query query) {
            this.newQuery.setQueryPattern(query.getQueryPattern());
        }

        @Override
        public void visitGroupBy(Query query) {
            if (query.hasGroupBy()) {
                VarExprList x = query.getGroupBy();
                for (Var v : x.getVars()) {
                    Expr expr = x.getExpr(v);
                    if (expr == null) {
                        this.newQuery.addGroupBy((Node)v);
                        continue;
                    }
                    this.newQuery.addGroupBy(v, expr);
                }
            }
        }

        @Override
        public void visitHaving(Query query) {
            if (query.hasHaving()) {
                for (Expr expr : query.getHavingExprs()) {
                    this.newQuery.addHavingCondition(expr);
                }
            }
        }

        @Override
        public void visitOrderBy(Query query) {
            if (query.hasOrderBy()) {
                for (SortCondition sc : query.getOrderBy()) {
                    this.newQuery.addOrderBy(sc);
                }
            }
        }

        @Override
        public void visitLimit(Query query) {
            this.newQuery.setLimit(query.getLimit());
        }

        @Override
        public void visitOffset(Query query) {
            this.newQuery.setOffset(query.getOffset());
        }

        @Override
        public void visitValues(Query query) {
            if (query.hasValues()) {
                this.newQuery.setValuesDataBlock(query.getValuesVariables(), query.getValuesData());
            }
        }

        @Override
        public void finishVisit(Query query) {
        }
    }
}

