/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store.tupletable;

import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.NullIterator;
import org.apache.jena.atlas.iterator.SingletonIterator;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.ColumnMap;
import org.apache.jena.atlas.lib.Tuple;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.base.record.Record;
import org.apache.jena.tdb.base.record.RecordFactory;
import org.apache.jena.tdb.index.RangeIndex;
import org.apache.jena.tdb.lib.TupleLib;
import org.apache.jena.tdb.store.NodeId;
import org.apache.jena.tdb.store.tupletable.TupleIndexBase;

public class TupleIndexRecord
extends TupleIndexBase {
    private static final boolean Check = false;
    private RangeIndex index;
    private RecordFactory factory;

    public TupleIndexRecord(int N, ColumnMap colMapping, String name, RecordFactory factory, RangeIndex index) {
        super(N, colMapping, name);
        this.factory = factory;
        this.index = index;
        if (factory.keyLength() != N * 8) {
            throw new TDBException(String.format("Mismatch: TupleIndex of length %d is not comparative with a factory for key length %d", N, factory.keyLength()));
        }
    }

    @Override
    protected boolean performAdd(Tuple<NodeId> tuple) {
        Record r = TupleLib.record(this.factory, tuple, this.colMap);
        return this.index.add(r);
    }

    @Override
    protected boolean performDelete(Tuple<NodeId> tuple) {
        Record r = TupleLib.record(this.factory, tuple, this.colMap);
        return this.index.delete(r);
    }

    @Override
    protected Iterator<Tuple<NodeId>> performFind(Tuple<NodeId> pattern) {
        return this.findOrScan(pattern);
    }

    final Iterator<Tuple<NodeId>> findOrScan(Tuple<NodeId> pattern) {
        return this.findWorker(pattern, true, true);
    }

    final Iterator<Tuple<NodeId>> findOrPartialScan(Tuple<NodeId> pattern) {
        return this.findWorker(pattern, true, false);
    }

    final Iterator<Tuple<NodeId>> findByIndex(Tuple<NodeId> pattern) {
        return this.findWorker(pattern, false, false);
    }

    private Iterator<Tuple<NodeId>> findWorker(Tuple<NodeId> patternNaturalOrder, boolean partialScanAllowed, boolean fullScanAllowed) {
        NodeId X;
        Tuple pattern = this.colMap.map(patternNaturalOrder);
        int numSlots = 0;
        int leadingIdx = -2;
        boolean leading = true;
        Record minRec = this.factory.createKeyOnly();
        Record maxRec = this.factory.createKeyOnly();
        for (int i = 0; i < pattern.size(); ++i) {
            X = (NodeId)pattern.get(i);
            if (NodeId.isAny(X)) {
                X = null;
                leading = false;
                continue;
            }
            ++numSlots;
            if (!leading) continue;
            leadingIdx = i;
            Bytes.setLong((long)X.getId(), (byte[])minRec.getKey(), (int)(i * 8));
            Bytes.setLong((long)X.getId(), (byte[])maxRec.getKey(), (int)(i * 8));
        }
        if (numSlots == pattern.size()) {
            if (this.index.contains(minRec)) {
                return new SingletonIterator((Object)pattern);
            }
            return new NullIterator();
        }
        Iterator<Record> iter = null;
        if (leadingIdx < 0) {
            if (!fullScanAllowed) {
                return null;
            }
            iter = this.index.iterator();
        } else {
            X = (NodeId)pattern.get(leadingIdx);
            Bytes.setLong((long)(X.getId() + 1L), (byte[])maxRec.getKey(), (int)(leadingIdx * 8));
            iter = this.index.iterator(minRec, maxRec);
        }
        Iterator<Tuple<NodeId>> tuples = Iter.map(iter, item -> TupleLib.tuple(item, this.colMap));
        if (leadingIdx < numSlots - 1) {
            if (!partialScanAllowed) {
                return null;
            }
            tuples = this.scan(tuples, patternNaturalOrder);
        }
        return tuples;
    }

    @Override
    public Iterator<Tuple<NodeId>> all() {
        Iterator<Record> iter = this.index.iterator();
        return Iter.map(iter, item -> TupleLib.tuple(item, this.colMap));
    }

    private Iterator<Tuple<NodeId>> scan(Iterator<Tuple<NodeId>> iter, final Tuple<NodeId> pattern) {
        Predicate<Tuple<NodeId>> filter = new Predicate<Tuple<NodeId>>(){

            @Override
            public boolean test(Tuple<NodeId> item) {
                for (int i = 0; i < TupleIndexRecord.this.tupleLength; ++i) {
                    NodeId n = (NodeId)pattern.get(i);
                    if (NodeId.isAny(n) || ((NodeId)item.get(i)).equals(n)) continue;
                    return false;
                }
                return true;
            }
        };
        return Iter.filter(iter, (Predicate)filter);
    }

    public void close() {
        this.index.close();
    }

    public void sync() {
        this.index.sync();
    }

    public final RangeIndex getRangeIndex() {
        return this.index;
    }

    @Override
    public boolean isEmpty() {
        return this.index.isEmpty();
    }

    @Override
    public void clear() {
        this.index.clear();
    }

    @Override
    public long size() {
        return this.index.size();
    }
}

